/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mod;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.simsilica.mod.ModInfo;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModInfoJson {
    static Logger log = LoggerFactory.getLogger(ModInfoJson.class);
    private static Gson gson;

    public static ModInfo load(File f) {
        try {
            String json = Files.toString((File)f, (Charset)Charsets.UTF_8);
            ModInfo result = (ModInfo)gson.fromJson(json, ModInfo.class);
            result.upgrade();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + f, e);
        }
    }

    public static ModInfo load(URL u) {
        try {
            String json = Resources.toString((URL)u, (Charset)Charsets.UTF_8);
            ModInfo result = (ModInfo)gson.fromJson(json, ModInfo.class);
            result.upgrade();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + u, e);
        }
    }

    public static ModInfo load(URI u) {
        try {
            return ModInfoJson.load(u.toURL());
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting to URL:" + u, e);
        }
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        gson = gsonBuilder.create();
    }
}

