/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Vec3d;

public class BodyMass {
    private double inverseMass;
    private Matrix3d inverseMassTensor;
    private Vec3d cog;
    private double radius;

    public BodyMass(double inverseMass, Matrix3d inverseMassTensor, Vec3d cog, double radius) {
        this.inverseMass = inverseMass;
        this.inverseMassTensor = inverseMassTensor;
        this.cog = cog;
        this.radius = radius;
    }

    public static BodyMass createSolidSphere(double mass, double radius, Vec3d cog) {
        if (mass == 0.0) {
            return BodyMass.createSimple(mass, cog, radius);
        }
        if (cog == null) {
            cog = new Vec3d();
        }
        Matrix3d inertiaTensor = new Matrix3d().makeIdentity();
        inertiaTensor.multLocal(0.4 * mass * radius * radius);
        Matrix3d inverseInertiaTensor = inertiaTensor.invert();
        return new BodyMass(1.0 / mass, inverseInertiaTensor, cog, radius);
    }

    public static BodyMass createSimple(double mass, Vec3d cog, double radius) {
        if (cog == null) {
            cog = new Vec3d();
        }
        if (mass == 0.0) {
            return new BodyMass(0.0, new Matrix3d().makeIdentity(), cog, radius);
        }
        return new BodyMass(1.0 / mass, new Matrix3d().makeIdentity().multLocal(1.0 / mass), cog, radius);
    }

    public final double getInverseMass() {
        return this.inverseMass;
    }

    public final Matrix3d getInverseMassTensor() {
        return this.inverseMassTensor;
    }

    public final Vec3d getCog() {
        return this.cog;
    }

    public final double getRadius() {
        return this.radius;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("inverseMass", this.inverseMass).add("inverseMassTensor", (Object)this.inverseMassTensor).add("cog", (Object)this.cog).add("radius", this.radius).toString();
    }
}

