/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.simsilica.lemur.Command;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodCommand<S>
implements Command<S> {
    private Object delegate;
    private Method method;

    public MethodCommand(Object delegate, String methodName) {
        this.delegate = delegate;
        try {
            this.method = delegate.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Cannot find method:" + methodName + " on " + delegate.getClass(), e);
        }
    }

    public MethodCommand(Object delegate, Method method) {
        this.delegate = delegate;
        this.method = method;
    }

    @Override
    public void execute(S source) {
        try {
            this.method.invoke(this.delegate, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error delegating to:" + this.method, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error delegating to:" + this.method, e);
        }
    }
}

