/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.event;

import com.jme3.app.Application;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.Vector2f;
import com.simsilica.lemur.event.BasePickState;
import com.simsilica.lemur.event.DefaultRawInputListener;

public class MouseAppState
extends BasePickState {
    private MouseObserver mouseObserver = new MouseObserver();
    private int scrollWheel = 0;

    public MouseAppState(Application app) {
        this.setEnabled(true);
        app.getInputManager().addRawInputListener((RawInputListener)this.mouseObserver);
    }

    @Override
    protected void cleanup(Application app) {
        app.getInputManager().removeRawInputListener((RawInputListener)this.mouseObserver);
        super.cleanup(app);
    }

    @Override
    protected void dispatchMotion() {
        Vector2f cursor = this.getApplication().getInputManager().getCursorPosition();
        this.getSession().cursorMoved((int)cursor.x, (int)cursor.y, this.scrollWheel);
    }

    protected void dispatch(MouseButtonEvent evt) {
        if (this.getSession().buttonEvent(evt.getButtonIndex(), evt.getX(), evt.getY(), evt.isPressed())) {
            evt.setConsumed();
        }
    }

    protected class MouseObserver
    extends DefaultRawInputListener {
        protected MouseObserver() {
        }

        @Override
        public void onMouseMotionEvent(MouseMotionEvent evt) {
            MouseAppState.this.scrollWheel = evt.getWheel();
        }

        @Override
        public void onMouseButtonEvent(MouseButtonEvent evt) {
            if (MouseAppState.this.isEnabled()) {
                MouseAppState.this.dispatch(evt);
            }
        }
    }
}

