/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys.collision;

import com.jme3.math.Vector2f;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockContact;
import com.simsilica.mblock.phys.RayHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WedgeCollider
implements Collider {
    static Logger log = LoggerFactory.getLogger(WedgeCollider.class);
    private final String name;
    private final Vec3d min;
    private final Vec3d max;
    private final BoundaryShapes.Triangle triangle;
    private final Vec3d triangleOrigin;
    private final Vec3d worldNormal;
    private final int rotation;
    private final Direction solidDirection;
    private final Direction dir;
    private final Direction up;
    private final Direction right;
    private final Vec3d origin;
    private final Vec3d xDir;
    private final Vec3d yDir;
    private final Vec3d zDir;
    private final Vec3d triNormal;
    private final double xMin;
    private final double yMin;
    private final double xMax;
    private final double yMax;
    private final double planeDist;
    private final int xPosMask;
    private final int xNegMask;
    private final int yPosMask;
    private final int yNegMask;
    private final int zPosMask;
    private final int zNegMask;

    public WedgeCollider(Vec3d min, Vec3d max, int rotation, Direction upDirection, BoundaryShapes.Triangle triangle, String name) {
        Vector2f tMax;
        Vector2f tMin;
        block13: {
            block12: {
                this.name = name;
                this.min = min;
                this.max = max;
                this.triangle = triangle;
                this.rotation = rotation;
                this.solidDirection = Direction.cardinalDirection((int)rotation);
                this.dir = this.solidDirection.reverse();
                this.up = upDirection;
                this.xDir = this.dir.getVec3i().toVec3d();
                this.yDir = this.up.getVec3i().toVec3d();
                this.zDir = this.xDir.cross(this.yDir);
                this.right = Direction.findDirection((Vec3d)this.zDir, (double)0.001);
                this.origin = new Vec3d();
                double nx = triangle.getNormal().x;
                tMin = triangle.getMin();
                tMax = triangle.getMax();
                double ny = triangle.getNormal().y;
                this.triNormal = new Vec3d(Math.abs(nx), Math.abs(ny), 0.0).normalizeLocal();
                this.triangleOrigin = new Vec3d();
                if (upDirection != Direction.Up) break block12;
                switch (this.solidDirection) {
                    case North: {
                        this.triangleOrigin.x = 1.0;
                        this.triangleOrigin.y = tMin.y;
                        this.triangleOrigin.z = tMin.x;
                        this.xMin = -tMin.x;
                        this.yMin = -tMin.y;
                        break block13;
                    }
                    case South: {
                        this.triangleOrigin.x = 0.0;
                        this.triangleOrigin.y = tMin.y;
                        this.triangleOrigin.z = tMax.x;
                        this.xMin = tMax.x - 1.0f;
                        this.yMin = -tMin.y;
                        break block13;
                    }
                    case East: {
                        this.triangleOrigin.x = tMax.x;
                        this.triangleOrigin.y = tMin.y;
                        this.triangleOrigin.z = 1.0;
                        this.xMin = tMax.x - 1.0f;
                        this.yMin = -tMin.y;
                        break block13;
                    }
                    case West: {
                        this.triangleOrigin.x = tMin.x;
                        this.triangleOrigin.y = tMin.y;
                        this.triangleOrigin.z = 0.0;
                        this.xMin = -tMin.x;
                        this.yMin = -tMin.y;
                        break block13;
                    }
                    default: {
                        throw new UnsupportedOperationException("Can't yet handle:" + this.solidDirection);
                    }
                }
            }
            switch (this.solidDirection) {
                case North: {
                    this.triangleOrigin.x = 0.0;
                    this.triangleOrigin.y = tMax.y;
                    this.triangleOrigin.z = tMin.x;
                    this.xMin = -tMin.x;
                    this.yMin = tMax.y - 1.0f;
                    break;
                }
                case South: {
                    this.triangleOrigin.x = 1.0;
                    this.triangleOrigin.y = tMax.y;
                    this.triangleOrigin.z = tMax.x;
                    this.xMin = tMax.x - 1.0f;
                    this.yMin = tMax.y - 1.0f;
                    break;
                }
                case East: {
                    this.triangleOrigin.x = tMax.x;
                    this.triangleOrigin.y = tMax.y;
                    this.triangleOrigin.z = 0.0;
                    this.xMin = tMax.x - 1.0f;
                    this.yMin = tMax.y - 1.0f;
                    break;
                }
                case West: {
                    this.triangleOrigin.x = tMin.x;
                    this.triangleOrigin.y = tMax.y;
                    this.triangleOrigin.z = 1.0;
                    this.xMin = -tMin.x;
                    this.yMin = tMax.y - 1.0f;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Can't yet handle:" + this.solidDirection);
                }
            }
        }
        this.xMax = tMax.x - tMin.x;
        this.yMax = tMax.y - tMin.y;
        this.planeDist = this.xMax * this.triNormal.x;
        this.worldNormal = this.xDir.mult(this.triNormal.x).addLocal(this.yDir.mult(this.triNormal.y)).addLocal(this.zDir.mult(this.triNormal.z));
        this.xPosMask = this.dir.getBitMask();
        this.xNegMask = this.dir.reverse().getBitMask();
        this.yPosMask = this.up.getBitMask();
        this.yNegMask = this.up.reverse().getBitMask();
        this.zPosMask = this.right.getBitMask();
        this.zNegMask = this.right.reverse().getBitMask();
    }

    public MBlockContact getSphereContact(Vec3d cellOrigin, Vec3d pos, double radius, int dirMask) {
        Vec3d triRelative = pos.clone();
        triRelative.x -= cellOrigin.x + this.triangleOrigin.x;
        triRelative.y -= cellOrigin.y + this.triangleOrigin.y;
        triRelative.z -= cellOrigin.z + this.triangleOrigin.z;
        Vec3d cellRelative = pos.subtract(cellOrigin);
        double x = this.xDir.dot(triRelative);
        if (x + radius <= this.xMin || x - radius >= this.xMax) {
            return null;
        }
        if (x < this.xMin && (dirMask & this.xNegMask) == 0) {
            return null;
        }
        double y = this.yDir.dot(triRelative);
        if (y + radius < this.yMin || y - radius >= this.yMax) {
            return null;
        }
        if (y < this.yMin && (dirMask & this.yNegMask) == 0) {
            return null;
        }
        double z = this.zDir.dot(triRelative);
        if (z + radius < 0.0 || z - radius > 1.0) {
            return null;
        }
        if (z < 0.0 && (dirMask & this.zNegMask) == 0) {
            return null;
        }
        if (z > 1.0 && (dirMask & this.zPosMask) == 0) {
            return null;
        }
        double slopeDist = this.triNormal.dot(x, y, z);
        if (slopeDist >= this.planeDist + radius) {
            return null;
        }
        double dist = slopeDist - this.planeDist;
        double spx = x - this.triNormal.x * dist;
        double spy = y - this.triNormal.y * dist;
        double spz = z;
        double bpx = x;
        double bpy = y;
        double bpz = z;
        double cpDist = dist;
        boolean outsideVolume = false;
        boolean clampedSlopePoint = false;
        boolean belowSlope = dist < 0.0 || y < 0.0;
        double bxNormal = 0.0;
        double byNormal = 0.0;
        double bzNormal = 0.0;
        double sideDist = Double.POSITIVE_INFINITY;
        if (belowSlope) {
            if (x < this.xMin) {
                bpx = this.xMin;
                outsideVolume = true;
                sideDist = 0.0;
            } else if (x > this.xMax) {
                bpx = this.xMax;
                outsideVolume = true;
                sideDist = 0.0;
            } else {
                bpx = x;
                if (x - this.xMin < this.xMax - x) {
                    if (x - this.xMin < sideDist) {
                        bxNormal = -1.0;
                        sideDist = x - this.xMin;
                    }
                } else if (this.xMax - x < sideDist) {
                    bxNormal = 1.0;
                    sideDist = this.xMax - x;
                }
            }
            if (y < this.yMin) {
                bpy = this.yMin;
                outsideVolume = true;
                sideDist = 0.0;
                bxNormal = 0.0;
            } else if (y > this.yMax) {
                bpy = this.yMax;
                outsideVolume = true;
                sideDist = 0.0;
                bxNormal = 0.0;
            } else {
                bpy = y;
                if (y - this.yMin < this.yMax - y) {
                    if (y - this.yMin < sideDist) {
                        bxNormal = 0.0;
                        byNormal = -1.0;
                        sideDist = y - this.yMin;
                    }
                } else if (this.yMax - y < sideDist) {
                    bxNormal = 0.0;
                    byNormal = 1.0;
                    sideDist = this.yMax - y;
                }
            }
            if (z < 0.0) {
                bpz = 0.0;
                outsideVolume = true;
                sideDist = 0.0;
                bxNormal = 0.0;
                byNormal = 0.0;
            } else if (z > 1.0) {
                bpz = 1.0;
                outsideVolume = true;
                sideDist = 0.0;
                bxNormal = 0.0;
                byNormal = 0.0;
            } else {
                bpz = z;
                if (z < 1.0 - z) {
                    if (z < sideDist) {
                        bxNormal = 0.0;
                        byNormal = 0.0;
                        bzNormal = -1.0;
                        sideDist = z;
                    }
                } else if (1.0 - z < sideDist) {
                    bxNormal = 0.0;
                    byNormal = 0.0;
                    bzNormal = 1.0;
                    sideDist = 1.0 - z;
                }
            }
        }
        if (!outsideVolume) {
            if (spx < this.xMin) {
                spx = this.xMin;
                clampedSlopePoint = true;
            } else if (spx > this.xMax) {
                spx = this.xMax;
                clampedSlopePoint = true;
                spy = 0.0;
            }
            if (spy < this.yMin) {
                spy = this.yMin;
                clampedSlopePoint = true;
            } else if (spy > this.yMax) {
                spy = this.yMax;
                clampedSlopePoint = true;
            }
            if (spz < 0.0) {
                spz = 0.0;
                clampedSlopePoint = true;
            } else if (spz > 1.0) {
                spz = 1.0;
                clampedSlopePoint = true;
            }
        }
        double cpx = 0.0;
        double cpy = 0.0;
        double cpz = 0.0;
        double cpDistMult = 1.0;
        if (belowSlope && sideDist < Math.abs(slopeDist - this.planeDist)) {
            double d = cpDistMult = outsideVolume ? 1.0 : -1.0;
            cpx = bxNormal < 0.0 ? this.xMin : (bxNormal > 0.0 ? this.xMax : bpx);
            cpy = byNormal < 0.0 ? this.yMin : (byNormal > 0.0 ? this.yMax : bpy);
            cpz = bzNormal < 0.0 ? 0.0 : (bzNormal > 0.0 ? 1.0 : bpz);
        } else {
            if (belowSlope) {
                cpDistMult = -1.0;
            }
            cpx = spx;
            cpy = spy;
            cpz = spz;
        }
        Vec3d cp = this.triangleOrigin.add(this.xDir.mult(cpx)).addLocal(this.yDir.mult(cpy)).addLocal(this.zDir.mult(cpz));
        cpDist = cellRelative.distance(cp);
        cpDist *= cpDistMult;
        if (cpDist > radius) {
            return null;
        }
        MBlockContact result = new MBlockContact();
        result.contactPoint = cp.addLocal(cellOrigin);
        result.contactNormal = pos.subtract(cp).normalizeLocal();
        if (cpDist == 0.0) {
            result.penetration = radius;
            if (dist == 0.0) {
                result.contactNormal = this.worldNormal.clone();
            } else if (Math.abs(x - this.xMin) < 1.0E-4) {
                result.contactNormal = this.xDir.mult(-1.0);
            } else if (Math.abs(x - this.xMax) < 1.0E-4) {
                result.contactNormal = this.xDir.clone();
            } else if (Math.abs(y - this.yMin) < 1.0E-4) {
                result.contactNormal = this.yDir.mult(-1.0);
            } else if (Math.abs(y - this.yMax) < 1.0E-4) {
                result.contactNormal = this.yDir.clone();
            } else if (Math.abs(z - 0.0) < 1.0E-4) {
                result.contactNormal = this.zDir.mult(-1.0);
            } else if (Math.abs(z - 1.0) < 1.0E-4) {
                result.contactNormal = this.zDir.clone();
            }
        } else if (cpDist < 0.0) {
            result.penetration = radius - cpDist;
            result.contactNormal.multLocal(-1.0);
        } else {
            result.penetration = radius - cpDist;
        }
        return result;
    }

    public MBlockContact getCubeContact(Vec3d cellOrigin, Vec3d pos, double radius, int dirMask) {
        return this.getSphereContact(cellOrigin, pos, radius, dirMask);
    }

    @Override
    public RayHit getHit(Vec3d origin, Vec3d dir, int dirMask, RayHit store) {
        int i;
        int i2;
        boolean inside = true;
        int[] quadrant = new int[3];
        double[] maxT = new double[3];
        double[] candidatePlane = new double[3];
        for (i2 = 0; i2 < 3; ++i2) {
            if (origin.get(i2) < this.min.get(i2)) {
                quadrant[i2] = 1;
                candidatePlane[i2] = this.min.get(i2);
                inside = false;
                continue;
            }
            if (origin.get(i2) > this.max.get(i2)) {
                quadrant[i2] = 0;
                candidatePlane[i2] = this.max.get(i2);
                inside = false;
                continue;
            }
            quadrant[i2] = 2;
        }
        if (inside) {
            return null;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            maxT[i2] = quadrant[i2] != 2 && dir.get(i2) != 0.0 ? (candidatePlane[i2] - origin.get(i2)) / dir.get(i2) : -1.0;
        }
        int whichPlane = 0;
        for (i = 1; i < 3; ++i) {
            if (!(maxT[i] > maxT[whichPlane])) continue;
            whichPlane = i;
        }
        if (maxT[whichPlane] < 0.0) {
            return null;
        }
        if (store == null) {
            store = new RayHit();
        }
        for (i = 0; i < 3; ++i) {
            if (whichPlane != i) {
                store.point.set(i, origin.get(i) + maxT[whichPlane] * dir.get(i));
                store.normal.set(i, 0.0);
                if (!(store.point.get(i) < this.min.get(i)) && !(store.point.get(i) > this.max.get(i))) continue;
                return null;
            }
            store.point.set(i, candidatePlane[i]);
            store.normal.set(i, quadrant[i] == 0 ? 1.0 : -1.0);
        }
        return store;
    }
}

