/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.IndexedField;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.TileId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerInfo
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(TriggerInfo.class);
    @IndexedField
    private long tileId;
    private short xSize;
    private short ySize;
    private short zSize;
    private short approachDistance;
    private EntityId visibleTo;

    protected TriggerInfo() {
    }

    public TriggerInfo(TileId tileId, int xSize, int ySize, int zSize, int approachDistance) {
        this(tileId, xSize, ySize, zSize, approachDistance, null);
    }

    public TriggerInfo(TileId tileId, int xSize, int ySize, int zSize, int approachDistance, EntityId visibleTo) {
        this.tileId = tileId.getId();
        this.xSize = (short)xSize;
        this.ySize = (short)ySize;
        this.zSize = (short)zSize;
        this.approachDistance = (short)approachDistance;
        this.visibleTo = visibleTo;
    }

    public static TriggerInfo create(TileId tileId, int xSize, int ySize, int zSize, int approachDistance) {
        return TriggerInfo.create(tileId, xSize, ySize, zSize, approachDistance, null);
    }

    public static TriggerInfo create(TileId tileId, int xSize, int ySize, int zSize, int approachDistance, EntityId visibleTo) {
        return new TriggerInfo(tileId, xSize, ySize, zSize, approachDistance, visibleTo);
    }

    public static TriggerInfo create(TileId tileId, int radius, int approachDistance) {
        return TriggerInfo.create(tileId, radius, 0, 0, approachDistance, null);
    }

    public static TriggerInfo create(TileId tileId, int radius, int approachDistance, EntityId visibleTo) {
        return new TriggerInfo(tileId, radius, 0, 0, approachDistance, visibleTo);
    }

    public TriggerInfo changeVisibility(EntityId visibleTo) {
        return new TriggerInfo(new TileId(this.tileId), this.xSize, this.ySize, this.zSize, this.approachDistance, visibleTo);
    }

    public static ComponentFilter<TriggerInfo> tileFilter(TileId tileId) {
        ComponentFilter filter = Filters.fieldEquals(TriggerInfo.class, (String)"tileId", (Object)tileId.getId());
        return filter;
    }

    public TileId getTiledId() {
        return new TileId(this.tileId);
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getZSize() {
        return this.zSize;
    }

    public Vec3i getSize() {
        return new Vec3i((int)this.xSize, (int)this.ySize, (int)this.zSize);
    }

    public int getApproachDistance() {
        return this.approachDistance;
    }

    public EntityId getVisibleTo() {
        return this.visibleTo;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("tileId", this.tileId).add("xSize", (int)this.xSize).add("ySize", (int)this.ySize).add("zSize", (int)this.zSize).add("approachDistance", (int)this.approachDistance).add("visibleTo", (Object)this.visibleTo).toString();
    }
}

