/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.es.StringIndex;
import com.simsilica.es.server.EntityDataHostedService;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.io.SerializationUtils;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.db.CellArrayStorage;
import com.simsilica.mworld.io.CellArrayProtocol;
import com.simsilica.sim.GameSystemManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import mythruna.assembly.Subassembly;
import mythruna.assembly.db.SubassemblyId;
import mythruna.assembly.db.SubassemblyStorage;
import mythruna.assembly.io.SubassemblyProtocol;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.io.FabricTypeData;
import mythruna.fabric.io.SwatchShapeData;
import mythruna.net.AccountEvent;
import mythruna.net.DataRequest;
import mythruna.net.DataSession;
import mythruna.net.DataSessionListener;
import mythruna.text.TextDb;
import mythruna.text.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSessionHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(DataSessionHostedService.class);
    private static final String ATTRIBUTE_SESSION = DataSession.class.getName();
    private GameSystemManager gameSystems;
    private RmiHostedService rmiService;
    private byte channel;
    private TextDb textDb;
    private int poolSize = 4;
    private ExecutorService workers;
    private StringIndex strings;
    private Map<Integer, String> idCache = new HashMap<Integer, String>();
    private Map<String, Function<Object[], Object>> requestHandlers = new ConcurrentHashMap<String, Function<Object[], Object>>();

    public DataSessionHostedService(GameSystemManager gameSystems, TextDb textDb, int channel) {
        this.gameSystems = gameSystems;
        this.textDb = textDb;
        this.channel = (byte)channel;
        this.setAutoHost(false);
    }

    public void registerDataRequestHandler(String requestType, Function<Object[], Object> handler) {
        this.requestHandlers.put(requestType, handler);
        if (this.strings != null) {
            int id = this.strings.getStringId(requestType, true);
            this.idCache.put(id, requestType);
        }
    }

    protected DataSessionImpl getSession(HostedConnection conn) {
        return (DataSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("DataSessionHostedService requires an RMI service.");
        }
        EventBus.addListener((Object)((Object)this), (EventType[])new EventType[]{AccountEvent.accountLoggedOn, AccountEvent.accountLoggedOff});
        ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("data-request-pool-%d");
        this.workers = Executors.newFixedThreadPool(this.poolSize, factoryBuilder.build());
    }

    public void start() {
        super.start();
        EntityDataHostedService eds = (EntityDataHostedService)this.getService(EntityDataHostedService.class);
        if (eds == null) {
            throw new RuntimeException("AccountHostedService requires an EntityDataHostedService");
        }
        this.strings = eds.getEntityData().getStrings();
        for (String requestType : this.requestHandlers.keySet()) {
            int id = this.strings.getStringId(requestType, true);
            this.idCache.put(id, requestType);
        }
    }

    public void terminate(HostedServiceManager serviceManager) {
        this.workers.shutdownNow();
        try {
            this.workers.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted terminating worker pool", (Throwable)e);
        }
        super.terminate((ServiceManager)serviceManager);
        EventBus.removeListener((Object)((Object)this), (EventType[])new EventType[]{AccountEvent.accountLoggedOn, AccountEvent.accountLoggedOff});
    }

    public void startHostingOnConnection(HostedConnection conn) {
        throw new UnsupportedOperationException("Autohosting not supported");
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        DataSessionImpl session = this.getSession(conn);
        if (session != null) {
            session.close();
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    protected void accountLoggedOn(AccountEvent event) {
        log.info("accountLoggedOn(" + event + ")");
        HostedConnection conn = event.getConnection();
        DataSessionImpl session = new DataSessionImpl(conn);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share(this.channel, (Object)session, DataSession.class);
        session.listener = (DataSessionListener)rmi.getRemoteObject(DataSessionListener.class);
        if (session.listener == null) {
            throw new RuntimeException("Unable to locate client callback for DataSessionListener");
        }
        session.listener.dataAvailable();
    }

    protected void accountLoggedOff(AccountEvent event) {
        log.info("accountLoggedOff(" + event + ")");
        this.stopHostingOnConnection(event.getConnection());
    }

    private class DataSessionImpl
    implements DataSession {
        private HostedConnection conn;
        private Locale locale;
        private DataSessionListener listener;

        public DataSessionImpl(HostedConnection conn) {
            this.conn = conn;
        }

        public void close() {
            log.info("close():" + this);
        }

        @Override
        public byte[] getCellArrayBytes(long id) {
            CellArray array = ((CellArrayStorage)DataSessionHostedService.this.gameSystems.get(CellArrayStorage.class)).get(new CellArrayId(id));
            return CellArrayProtocol.toBytes((CellArray)array);
        }

        @Override
        public CellArray getCellArray(CellArrayId id) {
            return ((CellArrayStorage)DataSessionHostedService.this.gameSystems.get(CellArrayStorage.class)).get(id);
        }

        @Override
        public byte[] getSubassemblyBytes(long id) {
            Subassembly data = this.getSubassembly(new SubassemblyId(id));
            return SubassemblyProtocol.toBytes(data);
        }

        @Override
        public Subassembly getSubassembly(SubassemblyId id) {
            return ((SubassemblyStorage)DataSessionHostedService.this.gameSystems.get(SubassemblyStorage.class)).get(id);
        }

        @Override
        public void setLocale(String countryCode) {
            log.info("setLocale(" + countryCode + "): " + this);
            this.locale = new Locale(countryCode);
        }

        @Override
        public String getText(String id) {
            return DataSessionHostedService.this.textDb.getText(id, this.locale);
        }

        @Override
        public byte[] getTextData(String id) {
            String text = this.getText(id);
            return TextUtils.compress(text);
        }

        @Override
        public FabricTypeData getFabricTypeData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getFabricTypeDataBytes() {
            byte[] result = FabricTypeData.toBytes(FabricTypeIndex.toData());
            return result;
        }

        @Override
        public SwatchShapeData getSwatchShapeData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getSwatchShapeDataBytes() {
            log.info("getSwatchShapeDataBytes()");
            return SwatchShapeData.toBytes(SwatchShapeIndex.toData());
        }

        @Override
        public <T> void requestData(DataRequest<T> request) {
            Function<Object[], Object> handler = DataSessionHostedService.this.requestHandlers.get(request.getRequestType());
            if (handler == null) {
                throw new IllegalArgumentException("No handler registered for request type:" + request.getRequestType());
            }
            T result = request.getDataType().cast(handler.apply(request.getArgs()));
            request.getCallback().accept(result);
        }

        @Override
        public void requestData(long requestId, int requestTypeId, Object[] args, boolean zipped) {
            String requestType = DataSessionHostedService.this.idCache.get(requestTypeId);
            Function<Object[], Object> handler = DataSessionHostedService.this.requestHandlers.get(requestType);
            if (handler == null) {
                throw new IllegalArgumentException("No handler registered for request type:" + requestTypeId + "(" + requestType + ")");
            }
            DataSessionHostedService.this.workers.execute(new DataRequestJob(DataSessionHostedService.this, this.listener, requestId, requestTypeId, args, zipped, handler));
        }
    }

    private class DataRequestJob
    implements Runnable {
        private DataSessionListener listener;
        private long requestId;
        private int requestTypeId;
        private Function<Object[], Object> handler;
        private Object[] args;
        private boolean zipped;

        public DataRequestJob(DataSessionHostedService dataSessionHostedService, DataSessionListener listener, long requestId, int requestTypeId, Object[] args, boolean zipped, Function<Object[], Object> handler) {
            this.listener = listener;
            this.requestId = requestId;
            this.requestTypeId = requestTypeId;
            this.args = args;
            this.zipped = zipped;
            this.handler = handler;
        }

        public void doSend() {
            Object result = this.handler.apply(this.args);
            byte[][] packets = SerializationUtils.objectToPackets((Object)result, (int)1024, (boolean)this.zipped);
            for (int i = 0; i < packets.length; ++i) {
                this.listener.dataReceived(this.requestId, i, packets.length, packets[i]);
            }
        }

        @Override
        public void run() {
            try {
                this.doSend();
            }
            catch (Exception e) {
                log.error("Error processing request:" + this.requestId + ", requestTypeId:" + this.requestTypeId + ", " + Arrays.toString(this.args), (Throwable)e);
                this.listener.dataReceived(this.requestId, 0, -1, null);
            }
        }
    }
}

