/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simsilica.es.StringIndex;
import com.simsilica.es.sql.SqlEntityData;
import com.simsilica.es.sql.SqlSession;
import com.simsilica.es.sql.StringTable;
import com.simsilica.util.ReportSystem;
import com.simsilica.util.Reporter;
import java.io.PrintWriter;
import java.sql.SQLException;

public class SqlStringIndex
implements StringIndex {
    private SqlEntityData parent;
    private StringTable stringTable;
    private Cache<Integer, String> idToString;
    private Cache<String, Integer> stringToId;

    public SqlStringIndex(SqlEntityData parent, int maxIndexedStringSize, int cacheSize) {
        this.parent = parent;
        this.idToString = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
        this.stringToId = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
        ReportSystem.registerCacheReporter(new CacheReporter());
        try {
            this.stringTable = StringTable.create(parent.getSession(), maxIndexedStringSize);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error creating string table", e);
        }
    }

    protected SqlSession getSession() throws SQLException {
        return this.parent.getSession();
    }

    protected int lookupId(String s) {
        try {
            return this.stringTable.getStringId(this.getSession(), s, false);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting string ID for:" + s, e);
        }
    }

    @Override
    public int getStringId(String s, boolean add) {
        Integer result = (Integer)this.stringToId.getIfPresent((Object)s);
        if (result != null) {
            return result;
        }
        int i = this.lookupId(s);
        if (i < 0 && add) {
            SqlStringIndex sqlStringIndex = this;
            synchronized (sqlStringIndex) {
                result = (Integer)this.stringToId.getIfPresent((Object)s);
                if (result != null) {
                    return result;
                }
                try {
                    i = this.stringTable.getStringId(this.getSession(), s, add);
                    if (i < 0) {
                        return -1;
                    }
                    this.stringToId.put((Object)s, (Object)i);
                    this.idToString.put((Object)i, (Object)s);
                    return i;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error getting string ID for:" + s, e);
                }
            }
        }
        if (i < 0) {
            return -1;
        }
        this.stringToId.put((Object)s, (Object)i);
        this.idToString.put((Object)i, (Object)s);
        return i;
    }

    @Override
    public String getString(int id) {
        String result = (String)this.idToString.getIfPresent((Object)id);
        if (result != null) {
            return result;
        }
        try {
            result = this.stringTable.getString(this.getSession(), id);
            if (result != null) {
                this.idToString.put((Object)id, (Object)result);
                this.stringToId.put((Object)result, (Object)id);
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting string for ID:" + id, e);
        }
    }

    private class CacheReporter
    implements Reporter {
        private CacheReporter() {
        }

        @Override
        public void printReport(String type, PrintWriter out) {
            out.println("SqlStringIndex->id to string:" + SqlStringIndex.this.idToString.size() + " stats:" + SqlStringIndex.this.idToString.stats());
            out.println("SqlStringIndex->string to id:" + SqlStringIndex.this.stringToId.size() + " stats:" + SqlStringIndex.this.stringToId.stats());
        }
    }
}

