/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3i;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.item.ContainerSection;
import mythruna.client.ui.item.Item;
import mythruna.client.ui.item.ItemContainer;
import mythruna.client.ui.item.ItemContainerView;
import mythruna.client.ui.item.ItemListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ItemViewState.class);
    private Node containerRoot = new Node("containers");
    private double zoom = 20.0;
    private Map<EntityId, ItemContainerView> viewIndex = new HashMap<EntityId, ItemContainerView>();
    private ItemObserver itemObserver = new ItemObserver(this);

    public void addItemListener(ItemListener itemListener) {
        this.itemObserver.listeners.add((Object)itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemObserver.listeners.remove((Object)itemListener);
    }

    public boolean hasItemContainer(EntityId entityId) {
        return this.viewIndex.containsKey(entityId);
    }

    public boolean hasItemContainer(ItemContainer container) {
        return this.hasItemContainer(container.getEntityId());
    }

    public void removeItemContainer(EntityId entityId) {
        ItemContainerView view = this.viewIndex.remove(entityId);
        if (view == null) {
            throw new IllegalStateException("No view found for:" + entityId);
        }
        view.removeFromParent();
    }

    public ItemContainerView addItemContainer(ItemContainer container) {
        ItemContainerView view = this.viewIndex.get(container.getEntityId());
        if (view != null) {
            throw new IllegalStateException("Container was already added:" + container);
        }
        view = new ItemContainerView(this.containerRoot, container, this.itemObserver);
        this.viewIndex.put(container.getEntityId(), view);
        this.containerRoot.attachChild((Spatial)view);
        return view;
    }

    public void removeItemContainer(ItemContainer container) {
        this.removeItemContainer(container.getEntityId());
    }

    protected void initialize(Application app) {
        log.info("initialize()");
        this.containerRoot.setLocalScale((float)this.zoom);
    }

    protected void cleanup(Application app) {
        log.info("cleanup()");
    }

    protected void onEnable() {
        log.info("onEnable()");
        ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).getRoot().attachChild((Spatial)this.containerRoot);
    }

    protected void onDisable() {
        log.info("onDisable()");
        this.containerRoot.removeFromParent();
    }

    private class ItemObserver
    implements ItemListener {
        private SafeArrayList<ItemListener> listeners = new SafeArrayList(ItemListener.class);

        private ItemObserver(ItemViewState itemViewState) {
        }

        @Override
        public void canCombine(Item source, Item target, Consumer<Boolean> callback) {
            for (ItemListener l : (ItemListener[])this.listeners.getArray()) {
                l.canCombine(source, target, callback);
            }
        }

        @Override
        public void combine(Item source, Item target, ContainerSection section) {
            for (ItemListener l : (ItemListener[])this.listeners.getArray()) {
                l.combine(source, target, section);
            }
        }

        @Override
        public void itemDropped(Item item, ContainerSection source, ContainerSection target, Vec3i slot) {
            for (ItemListener l : (ItemListener[])this.listeners.getArray()) {
                l.itemDropped(item, source, target, slot);
            }
        }

        @Override
        public void click(int button, int count, ContainerSection container, Item item, Vec3i slot) {
            for (ItemListener l : (ItemListener[])this.listeners.getArray()) {
                l.click(button, count, container, item, slot);
            }
        }
    }
}

