/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityCriteria;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import java.util.List;
import java.util.Objects;
import mythruna.client.ui.map.CustomMapLineEditor;
import mythruna.client.ui.map.DefaultMapToolLayer;
import mythruna.client.ui.map.LineQuad;
import mythruna.client.ui.map.LineWidget;
import mythruna.client.ui.map.MapPoint;
import mythruna.client.ui.map.MapToolState;
import mythruna.es.CustomMapLine;
import mythruna.es.OwnedBy;
import mythruna.net.GameSession;
import mythruna.shape.IconName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLineLayer
extends DefaultMapToolLayer {
    static Logger log = LoggerFactory.getLogger(CustomLineLayer.class);
    private GameSession gameSession;
    private EntityData ed;
    private MapToolState parent;
    private AssetManager assets;
    private Node root;
    private EntityId avatarId;
    private Vector2f clipRadius = new Vector2f(100.0f, 100.0f);
    private LineContainer lines;
    private VersionedReference<List<TileId>> visibleTilesRef;
    private LineView selected;
    private LineWidget lineWidget;
    private MapPoint draggedEnd;
    private Vec3d dragOffset;
    private CustomMapLineEditor editor;
    private Label helpText;

    public CustomLineLayer(GameSession gameSession, EntityData ed, MapToolState parent, AssetManager assets) {
        this.gameSession = gameSession;
        this.ed = ed;
        this.parent = parent;
        this.avatarId = gameSession.getAvatar();
        this.root = new Node("customLineRoot");
        this.assets = assets;
        this.root.move(0.0f, 0.0f, 0.5f);
        parent.getToolRoot().attachChild((Spatial)this.root);
        this.visibleTilesRef = parent.createVisibleTilesRef();
        this.lines = new LineContainer(this.avatarId, ed);
        this.lines.setVisibleTiles((List)this.visibleTilesRef.get());
        this.helpText = new Label("Line tool tips:\nLeft Mouse: Create\nRight Mouse: Move", new ElementId("help.tips.label"));
    }

    protected CustomMapLineEditor getEditor() {
        if (this.editor != null) {
            return this.editor;
        }
        this.editor = new CustomMapLineEditor(this.getToolId());
        return this.editor;
    }

    @Override
    public EntityId getEntityIdForCollision(Spatial collision) {
        LineView v = this.getLineView(collision);
        return v == null ? null : v.entity.getId();
    }

    @Override
    protected void onActivate() {
        this.parent.setLayerEditor((Panel)this.helpText);
    }

    @Override
    protected void onDeactivate() {
        this.parent.setLayerEditor(null);
    }

    @Override
    public void updateViewPort(Vector2f viewRadius) {
        this.clipRadius.set(viewRadius);
    }

    @Override
    public void start() {
        this.lines.start();
    }

    @Override
    public void update() {
        if (this.visibleTilesRef.update()) {
            this.lines.setVisibleTiles((List)this.visibleTilesRef.get());
        }
        this.lines.update();
        for (LineView v : this.lines.getArray()) {
            v.updatePosition();
        }
    }

    @Override
    public void stop() {
        this.lines.stop();
    }

    @Override
    public void hover(Vec3d world, Spatial collision) {
        if (collision.hasAncestor((Node)this.lineWidget)) {
            return;
        }
        this.setSelected(this.getLineView(collision));
    }

    @Override
    public void click(int button, Vec3d world, Spatial collision) {
        if (this.selected == null) {
            return;
        }
        if (button == 0) {
            log.info("edit:" + this.selected);
            GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)this.getEditor());
            this.getEditor().edit(this.getToolId(), this.selected.entity, this::doUpdate, this::doDelete);
        }
    }

    @Override
    public void startDrag(int button, Vec3d start, Vec3d end, Spatial collision) {
        this.draggedEnd = null;
        if (button == 0) {
            this.setSelected(null);
            this.showLineWidget(this.parent.createMapPoint(start), this.parent.createMapPoint(end));
            this.dragOffset = new Vec3d();
            this.draggedEnd = this.lineWidget.getEnd2();
        } else if (this.lineWidget != null) {
            this.draggedEnd = this.lineWidget.findEnd(collision);
            if (this.draggedEnd != null) {
                this.dragOffset = this.draggedEnd.getWorld().subtract(start);
                this.draggedEnd.setWorld(end.add(this.dragOffset));
            }
        }
    }

    @Override
    public void drag(int button, Vec3d start, Vec3d end, Spatial collision) {
        if (this.draggedEnd != null) {
            this.draggedEnd.setWorld(end.add(this.dragOffset));
        }
    }

    @Override
    public void endDrag(int button, Vec3d start, Vec3d end, Spatial collision) {
        this.draggedEnd = null;
        if (this.selected != null && this.lineWidget != null) {
            this.gameSession.runAction(this.getToolId(), "move", new Object[]{this.selected.entity.getId(), this.lineWidget.getEnd1().getWorld().clone(), this.lineWidget.getEnd2().getWorld().clone()});
        } else {
            this.gameSession.runAction(this.getToolId(), "create", new Object[]{CustomMapLine.create((Vec3d)start, (Vec3d)end, (String)"/Interface/line-styles.png(0,7)", (EntityData)this.ed), null});
        }
        this.clearLineWidget();
    }

    protected void setSelected(LineView selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        if (this.selected == null) {
            this.clearLineWidget();
        } else {
            this.showLineWidget(selected.end1, selected.end2);
            this.root.attachChild((Spatial)this.lineWidget);
        }
    }

    protected LineWidget showLineWidget(MapPoint end1, MapPoint end2) {
        if (this.lineWidget != null) {
            this.lineWidget.removeFromParent();
        }
        this.lineWidget = new LineWidget("lineSelectionTool", end1, end2, this.assets);
        this.lineWidget.setClipRadius(this.clipRadius);
        this.lineWidget.move(0.0f, 0.0f, 20.0f);
        this.root.attachChild((Spatial)this.lineWidget);
        return this.lineWidget;
    }

    protected void clearLineWidget() {
        if (this.lineWidget != null) {
            this.lineWidget.removeFromParent();
            this.lineWidget = null;
        }
    }

    protected LineView getLineView(Spatial collision) {
        EntityId hit = this.getEntityId(collision);
        if (hit == null) {
            return null;
        }
        return (LineView)this.lines.getObject(hit);
    }

    protected EntityId getEntityId(Spatial spatial) {
        for (Spatial s = spatial; s != null; s = s.getParent()) {
            if (s == this.root || s == this.parent.getMapRoot()) {
                return null;
            }
            Long id = (Long)s.getUserData("oid");
            if (id == null) continue;
            return new EntityId(id.longValue());
        }
        return null;
    }

    protected void doCreate(CustomMapLineEditor editor) {
        log.info("doCreate()");
    }

    protected void doUpdate(CustomMapLineEditor editor) {
        log.info("doUpdate()");
    }

    protected void doDelete(CustomMapLineEditor editor) {
        log.info("doDelete()");
        this.gameSession.runAction(this.getToolId(), "delete", new Object[]{editor.getEditing()});
    }

    private class LineContainer
    extends EntityContainer<LineView> {
        public LineContainer(EntityId avatarId, EntityData ed) {
            super(ed, new EntityCriteria().add(new Class[]{CustomMapLine.class}).add(new ComponentFilter[]{OwnedBy.filter((EntityId)avatarId)}));
        }

        public void setVisibleTiles(List<TileId> tiles) {
            EntityCriteria criteria = this.getCriteria();
            if (tiles.isEmpty()) {
                ComponentFilter filter1 = CustomMapLine.filterTileId((long)0L);
                ComponentFilter filter2 = CustomMapLine.filterTileId((long)1L);
                criteria.setFilter(CustomMapLine.class, Filters.and(CustomMapLine.class, (ComponentFilter[])new ComponentFilter[]{filter1, filter2}));
                this.setCriteria(criteria);
                return;
            }
            ComponentFilter[] filters = new ComponentFilter[tiles.size()];
            int index = 0;
            for (TileId id : tiles) {
                filters[index++] = CustomMapLine.filterTileId((long)id.getId());
            }
            criteria.setFilter(CustomMapLine.class, Filters.or(CustomMapLine.class, (ComponentFilter[])filters));
            this.setCriteria(criteria);
        }

        public LineView[] getArray() {
            return (LineView[])super.getArray();
        }

        protected LineView addObject(Entity entity) {
            LineView result = new LineView(entity);
            this.updateObject(result, entity);
            return result;
        }

        protected void updateObject(LineView object, Entity entity) {
            if (entity != object.entity) {
                log.error("That's really weird.");
            }
            object.updateData();
        }

        protected void removeObject(LineView object, Entity entity) {
            object.release();
        }
    }

    private class LineView {
        private Entity entity;
        private CustomMapLine mapLine;
        private String styleName;
        private LineQuad lineQuad;
        private Geometry geom;
        private Material material;
        private ColorRGBA color = new ColorRGBA(0.2f, 0.1f, 0.1f, 0.65f);
        private MapPoint end1;
        private MapPoint end2;
        private VersionedReference<MapPoint> end1Ref;
        private VersionedReference<MapPoint> end2Ref;

        public LineView(Entity entity) {
            this.entity = entity;
            this.end1 = CustomLineLayer.this.parent.createMapPoint(new Vec3d());
            this.end1Ref = this.end1.createReference();
            this.end2 = CustomLineLayer.this.parent.createMapPoint(new Vec3d());
            this.end2Ref = this.end2.createReference();
            this.buildGeometry("line:" + entity.getId());
            this.geom.setUserData("oid", (Object)entity.getId().getId());
            CustomLineLayer.this.root.attachChild((Spatial)this.geom);
        }

        protected void buildGeometry(String geomName) {
            this.lineQuad = new LineQuad(this.color);
            this.geom = new Geometry(geomName, this.lineQuad.getMesh());
            this.material = new Material(CustomLineLayer.this.assets, "MatDefs/LineQuad.j3md");
            this.material.setVector2("ClipRadius", CustomLineLayer.this.clipRadius);
            this.material.setColor("Color", ColorRGBA.White);
            this.geom.setMaterial(this.material);
            this.geom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        }

        public void updatePosition() {
            boolean changed = false;
            if (this.end1Ref.update()) {
                changed = true;
            }
            if (this.end2Ref.update()) {
                changed = true;
            }
            if (changed) {
                this.resetPosition();
            }
        }

        public void updateData() {
            this.mapLine = (CustomMapLine)this.entity.get(CustomMapLine.class);
            this.end1.setWorld(this.mapLine.getEnd1());
            this.end2.setWorld(this.mapLine.getEnd2());
            this.updateStyle(this.mapLine.getPatternName(CustomLineLayer.this.ed));
        }

        protected void updateStyle(String styleName) {
            float v2;
            float v1;
            if (Objects.equals(this.styleName, styleName)) {
                return;
            }
            this.styleName = styleName;
            IconName icon = IconName.parse((String)styleName);
            this.material.setTexture("Texture", GuiGlobals.getInstance().loadTexture(icon.getImageName(), false, false));
            Integer line = icon.getY();
            if (line == null) {
                v1 = 0.0f;
                v2 = 1.0f;
            } else {
                v1 = (float)line.intValue() / 8.0f;
                v2 = v1 + 0.125f;
            }
            this.lineQuad.updateStyle(v1, v2);
        }

        protected void resetPosition() {
            this.lineQuad.updateEnds(this.end1.getView(), this.end2.getView());
            this.geom.updateModelBound();
        }

        public void release() {
            this.geom.removeFromParent();
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.entity.getId() + "]";
        }
    }
}

