/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.util;

import com.jme3.network.HostedConnection;
import com.jme3.network.util.AbstractMessageDelegator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionDataDelegator
extends AbstractMessageDelegator<HostedConnection> {
    private static final Logger log = Logger.getLogger(SessionDataDelegator.class.getName());
    private String attributeName;

    public SessionDataDelegator(Class delegateType, String attributeName, boolean automap) {
        super(delegateType, automap);
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    protected void miss(HostedConnection source) {
        log.log(Level.WARNING, "Session data is null for:{0} on connection:{1}", new Object[]{this.attributeName, source});
    }

    @Override
    protected Object getSourceDelegate(HostedConnection source) {
        Object result = source.getAttribute(this.attributeName);
        if (result == null) {
            this.miss(source);
        }
        return result;
    }
}

