/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mathd.Grid;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.GridBasedId;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.WorldGrids;
import java.util.Objects;
import java.util.function.Consumer;

public class ColumnId
implements GridBasedId {
    public static final int SIZE = 32;
    public static final Grid GRID = WorldGrids.COLUMN_GRID;
    private long columnId;

    public ColumnId(long columnId) {
        this.columnId = columnId;
    }

    public static ColumnId fromWorld(Vec3i world) {
        return ColumnId.fromWorld(world.x, world.y, world.z);
    }

    public static ColumnId fromWorld(Vec3d world) {
        return ColumnId.fromWorld(world.x, world.y, world.z);
    }

    public static ColumnId fromWorld(double x, double y, double z) {
        long id = GRID.worldToId(x, y, z);
        return new ColumnId(id);
    }

    public static ColumnId fromWorld(int x, int y, int z) {
        long id = GRID.worldToId((double)x, (double)y, (double)z);
        return new ColumnId(id);
    }

    @Override
    public long getId() {
        return this.columnId;
    }

    @Override
    public Vec3i getWorld(Vec3i store) {
        Vec3i loc = GRID.idToCell(this.columnId, store);
        loc = GRID.cellToWorld(loc, loc);
        return loc;
    }

    @Override
    public GridCell getGridCell() {
        return this.getGrid().getContainingCell(this.getWorld(null));
    }

    public TileId getTileId() {
        Vec3i world = this.getWorld(null);
        return TileId.fromWorld(world);
    }

    public Vec3i getTileLocal(Vec3i store) {
        TileId tileId = this.getTileId();
        Vec3i local = this.getWorld(store);
        local.subtractLocal(tileId.getWorld(null));
        return local;
    }

    public Vec3i getTileLocalIndex(Vec3i store) {
        TileId tileId = this.getTileId();
        Vec3i local = this.getWorld(store);
        local.subtractLocal(tileId.getWorld(null));
        local.x /= 32;
        local.z /= 32;
        return local;
    }

    public short getTileLocalIndexId() {
        Vec3i local = this.getTileLocalIndex(null);
        return (short)(local.z << 5 | local.x);
    }

    public static short toTileLocalIndexId(int xLocal, int zLocal) {
        return (short)(zLocal << 5 | xLocal);
    }

    public static ColumnId fromTileLocalIndex(TileId id, int x, int z) {
        Vec3i world = id.getWorld(null);
        world.addLocal(x * 32, 0, z * 32);
        return ColumnId.fromWorld(world);
    }

    public static ColumnId fromTileLocal(TileId id, int x, int z) {
        Vec3i world = id.getWorld(null);
        world.addLocal(x, 0, z);
        return ColumnId.fromWorld(world);
    }

    public static ColumnId fromTileLocalIndexId(TileId id, short indexId) {
        int x = indexId & 0x1F;
        int z = indexId >> 5;
        return ColumnId.fromTileLocalIndex(id, x, z);
    }

    public LeafId[] getLeafIds(int yMax) {
        int leafCount = yMax / 32;
        LeafId[] result = new LeafId[leafCount];
        Vec3i base = this.getWorld(null);
        for (int i = 0; i < leafCount; ++i) {
            result[i] = LeafId.fromWorld(base.add(0, i * 32, 0));
        }
        return result;
    }

    public boolean contains(LeafId leafId) {
        if (leafId == null) {
            return false;
        }
        ColumnId colId = leafId.getColumnId();
        return colId.getId() == this.columnId;
    }

    public boolean contains(Vec3i world) {
        ColumnId id = ColumnId.fromWorld(world.x, world.y, world.z);
        return id.columnId == this.columnId;
    }

    @Override
    public Grid getGrid() {
        return GRID;
    }

    @Override
    public Grid getParentGrid() {
        return TileId.GRID;
    }

    public void visitNeighbors(int radius, Consumer<ColumnId> visitor) {
        Vec3i origin = this.getWorld(null);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                visitor.accept(ColumnId.fromWorld(origin.x + 32 * x, origin.y, origin.z + 32 * z));
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.columnId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ColumnId other = (ColumnId)o;
        return other.columnId == this.columnId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id:" + this.columnId + ", tileId:" + this.getTileId() + "]";
    }
}

