/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.sound;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.audio.AudioNode;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.anim.AbstractTween;
import com.simsilica.lemur.anim.AnimationState;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.core.VersionedReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import mythruna.client.GameSettingsState;
import mythruna.client.sound.AmbientSound;
import mythruna.client.sound.Sound;
import mythruna.client.sound.SoundType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(SoundState.class);
    private AnimationState anim;
    private Map<String, String> soundAliases = new HashMap<String, String>();
    private Sound music;
    private List<Sound> ambient = new ArrayList<Sound>();
    private SafeArrayList<Sound> activeSounds = new SafeArrayList(Sound.class);
    private VersionedReference<Boolean> muteRef;
    private VersionedReference<Double> musicVolumeRef;
    private VersionedReference<Double> ambientVolumeRef;
    private VersionedReference<Double> effectVolumeRef;
    private AmbientSound ambientSound;
    private float baseAmbientVolume;

    public void registerSound(String soundName, String asset) {
        this.soundAliases.put(soundName, asset);
    }

    public boolean isPlaying(String soundName) {
        for (Sound sound : this.activeSounds) {
            if (!Objects.equals(soundName, sound.getName())) continue;
            return true;
        }
        return false;
    }

    protected String getAsset(String soundName) {
        String asset = this.soundAliases.get(soundName);
        return asset == null ? soundName : asset;
    }

    public Sound playMusic(String soundName) {
        return this.playMusic(soundName, 1.0f);
    }

    public Sound playMusic(String soundName, float crossFade) {
        String asset = this.getAsset(soundName);
        if (this.music != null) {
            this.stop(this.music.getName(), crossFade);
        }
        this.music = new Sound(SoundType.Music, soundName, true, new AudioFactory(asset));
        this.music.setBaseVolume(this.getMusicVolume());
        this.activeSounds.add((Object)this.music);
        if (this.isInitialized()) {
            this.anim.add(new Tween[]{new VolumeTween(this.music, 0.0f, 1.0f, crossFade, false)});
            this.music.setVolume(0.0f);
            this.music.play();
        }
        return this.music;
    }

    protected float getMusicVolume() {
        if (this.muteRef == null || ((Boolean)this.muteRef.get()).booleanValue()) {
            return 0.0f;
        }
        return (float)((Double)this.musicVolumeRef.get() / 100.0);
    }

    protected float getAmbientVolume() {
        if (this.muteRef == null || ((Boolean)this.muteRef.get()).booleanValue()) {
            return 0.0f;
        }
        return (float)((Double)this.ambientVolumeRef.get() / 100.0);
    }

    protected float getEffectsVolume() {
        if (this.muteRef == null || ((Boolean)this.muteRef.get()).booleanValue()) {
            return 0.0f;
        }
        return (float)((Double)this.effectVolumeRef.get() / 100.0);
    }

    protected void resetBaseVolumes() {
        this.baseAmbientVolume = this.getAmbientVolume();
        block5: for (Sound sound : (Sound[])this.activeSounds.getArray()) {
            switch (sound.getType()) {
                case Music: {
                    sound.setBaseVolume(this.getMusicVolume());
                    continue block5;
                }
                case Ambient: {
                    sound.setBaseVolume(this.baseAmbientVolume);
                    continue block5;
                }
                case Effect: {
                    sound.setBaseVolume(this.getEffectsVolume());
                }
            }
        }
    }

    public Sound playEffect(String soundName) {
        log.info("playEffect(" + soundName + ")");
        String asset = this.getAsset(soundName);
        Sound sound = new Sound(SoundType.Effect, soundName, false, new AudioFactory(asset));
        sound.setBaseVolume(this.getEffectsVolume());
        this.activeSounds.add((Object)sound);
        if (this.isInitialized()) {
            sound.play();
        }
        return sound;
    }

    public Sound playAmbient(String soundName) {
        return this.playAmbient(soundName, 1.0f);
    }

    public Sound playAmbient(String soundName, float fadeLength) {
        String asset = this.getAsset(soundName);
        Sound sound = new Sound(SoundType.Ambient, soundName, false, new AudioFactory(asset));
        sound.setBaseVolume(this.getAmbientVolume());
        this.activeSounds.add((Object)sound);
        this.ambient.add(sound);
        if (this.isInitialized()) {
            if (fadeLength > 0.0f) {
                this.anim.add(new Tween[]{new VolumeTween(sound, 0.0f, 1.0f, fadeLength, false)});
                sound.setVolume(0.0f);
            }
            sound.play();
        }
        return sound;
    }

    public void stopAll() {
        this.stopAll(1.0f);
    }

    public void stopAll(float fadeLength) {
        for (Sound sound : (Sound[])this.activeSounds.getArray()) {
            this.anim.add(new Tween[]{new VolumeTween(sound, fadeLength)});
        }
        this.ambient.clear();
        this.music = null;
    }

    public void stop(String soundName) {
        this.stop(soundName, 1.0f);
    }

    public void stop(String soundName, float fadeLength) {
        Sound found = null;
        for (Sound sound : (Sound[])this.activeSounds.getArray()) {
            if (!Objects.equals(soundName, sound.getName())) continue;
            this.anim.add(new Tween[]{new VolumeTween(sound, fadeLength)});
            found = sound;
        }
        if (found == null) {
            return;
        }
        switch (found.getType()) {
            case Music: {
                if (found != this.music) break;
                this.music = null;
                break;
            }
            case Ambient: {
                this.ambient.remove(found);
            }
        }
    }

    protected void removeSound(Sound sound) {
        if (log.isTraceEnabled()) {
            log.trace("removeSound(" + sound + ")");
        }
        log.info("removeSound(" + sound + ")");
        sound.stop();
        this.activeSounds.remove((Object)sound);
        if (this.music == sound) {
            this.music = null;
        }
        this.ambient.remove(sound);
    }

    public AmbientSound getAmbientSound() {
        return this.ambientSound;
    }

    protected void initialize(Application app) {
        this.anim = (AnimationState)this.getState(AnimationState.class, true);
        this.muteRef = ((GameSettingsState)this.getState(GameSettingsState.class, true)).createMuteReference();
        this.musicVolumeRef = ((GameSettingsState)this.getState(GameSettingsState.class, true)).createMusicVolumeReference();
        this.ambientVolumeRef = ((GameSettingsState)this.getState(GameSettingsState.class, true)).createAmbientVolumeReference();
        this.effectVolumeRef = ((GameSettingsState)this.getState(GameSettingsState.class, true)).createEffectsVolumeReference();
        this.ambientSound = new AmbientSound(this);
        this.baseAmbientVolume = this.getAmbientVolume();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.resetBaseVolumes();
        if (this.music != null && !this.music.isPlaying()) {
            this.anim.add(new Tween[]{new VolumeTween(this.music, 0.0f, 1.0f, 1.0f, false)});
            this.music.setVolume(0.0f);
            this.music.play();
        }
        for (Sound sound : this.ambient) {
            if (sound.isPlaying()) continue;
            this.anim.add(new Tween[]{new VolumeTween(sound, 0.0f, 1.0f, 1.0f, false)});
            sound.setVolume(0.0f);
            sound.play();
        }
    }

    public void update(float tpf) {
        boolean baseVolumeChanged = false;
        if (this.musicVolumeRef.update()) {
            baseVolumeChanged = true;
        }
        if (this.ambientVolumeRef.update()) {
            baseVolumeChanged = true;
        }
        if (this.effectVolumeRef.update()) {
            baseVolumeChanged = true;
        }
        if (this.muteRef.update()) {
            baseVolumeChanged = true;
        }
        if (baseVolumeChanged) {
            this.resetBaseVolumes();
        }
        for (Sound sound : (Sound[])this.activeSounds.getArray()) {
            sound.update();
            if (sound.isPlaying() || sound.isLooping()) continue;
            this.removeSound(sound);
        }
        this.ambientSound.update(1.0);
    }

    protected void onDisable() {
        if (this.music != null) {
            this.music.stop();
        }
        for (Sound sound : this.ambient) {
            sound.stop();
        }
    }

    protected class AudioFactory
    implements Supplier<AudioNode> {
        private AudioKey key;

        public AudioFactory(String asset) {
            this(asset, true, false);
        }

        public AudioFactory(String asset, boolean streaming, boolean cached) {
            this(new AudioKey(asset, streaming, cached));
        }

        public AudioFactory(AudioKey key) {
            this.key = key;
        }

        @Override
        public AudioNode get() {
            try {
                AudioData data = SoundState.this.getApplication().getAssetManager().loadAudio(this.key);
                AudioNode node = new AudioNode(data, this.key);
                node.setPositional(false);
                return node;
            }
            catch (AssetNotFoundException e) {
                log.error("Asset not found:" + this.key, (Throwable)e);
                return null;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[key:" + this.key + "]";
        }
    }

    protected class VolumeTween
    extends AbstractTween {
        private Sound sound;
        private float startVolume;
        private float endVolume;
        private boolean removeWhenDone;

        public VolumeTween(Sound sound, float length) {
            this(sound, 0.0f, length, true);
        }

        public VolumeTween(Sound sound, float endVolume, float length, boolean removeWhenDone) {
            this(sound, sound.getVolume(), endVolume, length, removeWhenDone);
        }

        public VolumeTween(Sound sound, float startVolume, float endVolume, float length, boolean removeWhenDone) {
            super((double)length);
            this.sound = sound;
            this.startVolume = startVolume;
            this.endVolume = endVolume;
            this.removeWhenDone = removeWhenDone;
            if (log.isTraceEnabled()) {
                log.trace("VolumeTween(" + sound + ", " + startVolume + ", " + endVolume + ", " + length + ", " + removeWhenDone + ")");
            }
        }

        protected void doInterpolate(double t) {
            double v = (1.0 - t) * (double)this.startVolume + t * (double)this.endVolume;
            if (log.isTraceEnabled()) {
                log.trace("t:" + t + "  v:" + v);
            }
            this.sound.setVolume((float)v);
            if (this.removeWhenDone && t >= 1.0) {
                SoundState.this.removeSound(this.sound);
            }
        }
    }
}

