/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rmi;

import com.jme3.network.serializing.Serializable;
import com.jme3.network.service.rmi.MethodInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;

@Serializable
public final class ClassInfo {
    private String name;
    private short typeId;
    private MethodInfo[] methods;

    public ClassInfo() {
    }

    public ClassInfo(short typeId, Class type) {
        this.typeId = typeId;
        this.name = type.getName();
        this.methods = this.toMethodInfo(type, type.getMethods());
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        try {
            return Class.forName(this.name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error finding class for:" + this, e);
        }
    }

    public short getId() {
        return this.typeId;
    }

    public MethodInfo getMethod(short id) {
        return this.methods[id];
    }

    public MethodInfo getMethod(Method m) {
        for (MethodInfo mi : this.methods) {
            if (!mi.matches(m)) continue;
            return mi;
        }
        return null;
    }

    private MethodInfo[] toMethodInfo(Class type, Method[] methods) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        short methodId = 0;
        for (Method m : methods) {
            short s = methodId;
            methodId = (short)(methodId + 1);
            result.add(new MethodInfo(s, m));
        }
        return result.toArray(new MethodInfo[result.size()]);
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public String toString() {
        return "ClassInfo[" + this.name + "]";
    }
}

