/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Vec3d;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectVolume
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(ObjectVolume.class);
    private static final double BLOCK_DIV = 100.0;
    private long packedSize;

    public ObjectVolume() {
    }

    public ObjectVolume(Vec3d size) {
        this.packedSize = ObjectVolume.pack(size);
    }

    public Vec3d getSize() {
        return ObjectVolume.unpack(this.packedSize);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ObjectVolume other = (ObjectVolume)o;
        return other.packedSize != this.packedSize;
    }

    public int hashCode() {
        return Objects.hash(this.packedSize);
    }

    public static short toFixed(double val) {
        if (val < 0.0) {
            throw new UnsupportedOperationException("Negative values not supported:" + val);
        }
        long fp = Math.round(val * 100.0);
        if (fp > 65535L) {
            throw new IllegalArgumentException("Value exceeds max range:" + val);
        }
        return (short)fp;
    }

    public static double fromFixed(short val) {
        return (double)val / 100.0;
    }

    public static long pack3(short x, short y, short z) {
        long lx = x;
        long ly = y;
        long lz = z;
        long result = lx << 32 | ly << 16 | lz;
        return result;
    }

    public static int pack2(short y, short z) {
        return y << 16 | z;
    }

    public static short unpackX(long val) {
        long shifted = val >> 32;
        return (short)(shifted & 0xFFFFL);
    }

    public static short unpackY(long val) {
        long shifted = val >> 16;
        return (short)(shifted & 0xFFFFL);
    }

    public static short unpackZ(long val) {
        long shifted = val;
        return (short)(shifted & 0xFFFFL);
    }

    public static long pack(Vec3d v) {
        return ObjectVolume.pack3(ObjectVolume.toFixed(v.x), ObjectVolume.toFixed(v.y), ObjectVolume.toFixed(v.z));
    }

    public static Vec3d unpack(long val) {
        short x = ObjectVolume.unpackX(val);
        short y = ObjectVolume.unpackY(val);
        short z = ObjectVolume.unpackZ(val);
        Vec3d result = new Vec3d(ObjectVolume.fromFixed(x), ObjectVolume.fromFixed(y), ObjectVolume.fromFixed(z));
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("size", (Object)this.getSize()).toString();
    }
}

