/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.TileId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mythruna.world.cave.Influencer;
import mythruna.world.tile.Feature;
import mythruna.world.tile.FeatureId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaveNetwork
implements Feature<CaveNetwork>,
Serializable {
    static Logger log = LoggerFactory.getLogger(CaveNetwork.class);
    private static final long serialVersionUID = 42L;
    private FeatureId<CaveNetwork> id;
    private Set<TileId> affectedTiles = new HashSet<TileId>();
    private List<Influencer> influencers = new ArrayList<Influencer>();

    public CaveNetwork(FeatureId<CaveNetwork> id) {
        this.id = id;
    }

    public void setInfluencers(List<Influencer> influencers) {
        if (this.influencers == influencers) {
            return;
        }
        this.influencers.clear();
        this.influencers.addAll(influencers);
    }

    public void addInfluencer(Influencer influencer) {
        this.influencers.add(influencer);
        Vec3i min = influencer.getMin();
        Vec3i max = influencer.getMax();
        min = TileId.fromWorld((Vec3i)min).getWorld(null);
        max = TileId.fromWorld((Vec3i)max).getWorld(null);
        for (int x = min.x; x <= max.x; x += 1024) {
            for (int z = min.z; z <= max.z; z += 1024) {
                this.affectedTiles.add(TileId.fromWorld((int)x, (int)min.y, (int)z));
            }
        }
    }

    public List<Influencer> getInfluencers() {
        return this.influencers;
    }

    @Override
    public FeatureId<CaveNetwork> getFeatureId() {
        return this.id;
    }

    @Override
    public Collection<TileId> getAffectedTiles() {
        return this.affectedTiles;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id:" + this.id + ", influencers:" + this.influencers.size() + "]";
    }
}

