/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.anim;

import com.jme3.asset.AssetManager;
import com.jme3.scene.plugins.fbx.anim.FbxLimbNode;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FbxCluster
extends FbxObject {
    private static final Logger logger = Logger.getLogger(FbxCluster.class.getName());
    private int[] indexes;
    private double[] weights;
    private FbxLimbNode limb;

    public FbxCluster(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    @Override
    public void fromElement(FbxElement element) {
        super.fromElement(element);
        for (FbxElement e : element.children) {
            if (e.id.equals("Indexes")) {
                this.indexes = (int[])e.properties.get(0);
                continue;
            }
            if (!e.id.equals("Weights")) continue;
            this.weights = (double[])e.properties.get(0);
        }
    }

    public int[] getVertexIndices() {
        return this.indexes;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public FbxLimbNode getLimb() {
        return this.limb;
    }

    protected Object toJmeObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectObject(FbxObject object) {
        if (object instanceof FbxLimbNode) {
            if (this.limb != null) {
                logger.log(Level.WARNING, "This cluster already has a limb attached. Ignoring.");
                return;
            }
            this.limb = (FbxLimbNode)object;
        } else {
            this.unsupportedConnectObject(object);
        }
    }

    @Override
    public void connectObjectProperty(FbxObject object, String property) {
        this.unsupportedConnectObjectProperty(object, property);
    }
}

