/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.file;

import java.util.ArrayList;
import java.util.List;

public class FbxElement {
    public String id;
    public List<Object> properties;
    public char[] propertiesTypes;
    public List<FbxElement> children = new ArrayList<FbxElement>();

    public FbxElement(int propsCount) {
        this.properties = new ArrayList<Object>(propsCount);
        this.propertiesTypes = new char[propsCount];
    }

    public FbxElement getChildById(String name) {
        for (FbxElement element : this.children) {
            if (!element.id.equals(name)) continue;
            return element;
        }
        return null;
    }

    public List<FbxElement> getFbxProperties() {
        ArrayList<FbxElement> props = new ArrayList<FbxElement>();
        FbxElement propsElement = null;
        boolean legacy = false;
        for (FbxElement element : this.children) {
            if (element.id.equals("Properties70")) {
                propsElement = element;
                break;
            }
            if (!element.id.equals("Properties60")) continue;
            legacy = true;
            propsElement = element;
            break;
        }
        if (propsElement == null) {
            return props;
        }
        for (FbxElement prop : propsElement.children) {
            if (!prop.id.equals("P") && !prop.id.equals("Property")) continue;
            if (legacy) {
                char[] types = new char[prop.propertiesTypes.length + 1];
                types[0] = prop.propertiesTypes[0];
                types[1] = prop.propertiesTypes[0];
                System.arraycopy(prop.propertiesTypes, 1, types, 2, types.length - 2);
                ArrayList<Object> values = new ArrayList<Object>(prop.properties);
                values.add(1, values.get(0));
                FbxElement dummyProp = new FbxElement(types.length);
                dummyProp.children = prop.children;
                dummyProp.id = prop.id;
                dummyProp.propertiesTypes = types;
                dummyProp.properties = values;
                props.add(dummyProp);
                continue;
            }
            props.add(prop);
        }
        return props;
    }

    public String toString() {
        return "FBXElement[id=" + this.id + ", numProps=" + this.properties.size() + ", numChildren=" + this.children.size() + "]";
    }
}

