/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.value;

import com.google.common.base.Function;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.style.ElementId;

public class DefaultValueRenderer<T>
implements ValueRenderer<T>,
Cloneable {
    public static final ElementId DEFAULT_ID = new ElementId("label");
    private ElementId elementId;
    private String style;
    private Function<? super T, String> toString;

    public DefaultValueRenderer() {
        this(null, null, null);
    }

    public DefaultValueRenderer(Function<? super T, String> toString) {
        this(null, null, toString);
    }

    public DefaultValueRenderer(ElementId elementId, String style) {
        this(elementId, style, null);
    }

    public DefaultValueRenderer(ElementId elementId, String style, Function<? super T, String> toString) {
        this.style = style;
        this.elementId = elementId;
        this.toString = toString;
    }

    public DefaultValueRenderer<T> clone() {
        try {
            return (DefaultValueRenderer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning", e);
        }
    }

    @Override
    public void configureStyle(ElementId elementId, String style) {
        if (this.elementId == null) {
            this.elementId = elementId;
        }
        if (this.style == null) {
            this.style = style;
        }
    }

    public void setStringTransform(Function<? super T, String> toString) {
        this.toString = toString;
    }

    public Function<? super T, String> getStringTransform() {
        return this.toString;
    }

    public void setElementId(ElementId elementId) {
        this.elementId = elementId;
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    protected String valueToString(T value) {
        return this.toString != null ? (String)this.toString.apply(value) : String.valueOf(value);
    }

    protected Label createView(T value, boolean selected) {
        return new Label(this.valueToString(value), this.elementId, this.style);
    }

    @Override
    public Panel getView(T value, boolean selected, Panel existing) {
        if (existing == null) {
            existing = this.createView(value, selected);
        } else {
            ((Label)existing).setText(this.valueToString(value));
        }
        return existing;
    }
}

