/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.base.DefaultEntity;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ObjectStatusListener;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Bin;
import com.simsilica.mphys.BinIndex;
import com.simsilica.mphys.BinListener;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinEntityManager<S extends AbstractShape>
implements BinListener<EntityId, S> {
    static Logger log = LoggerFactory.getLogger(BinEntityManager.class);
    private EntityData ed;
    private BinIndex<EntityId, S> binIndex;
    private EntityChangeObserver entityListener = new EntityChangeObserver();
    private ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();
    private Map<EntityId, HoldingEntity> changeSet = new HashMap<EntityId, HoldingEntity>();
    private Set<EntityId> toRemove = new HashSet<EntityId>();
    private Class[] types = new Class[]{SpawnPosition.class, ShapeInfo.class, Mass.class};
    private Set<EntityId> skip = new HashSet<EntityId>();
    private Set<EntityId> loaded = new HashSet<EntityId>();
    private DynArray<ObjectStatusListener> listeners = new DynArray(ObjectStatusListener.class);

    public BinEntityManager(EntityData ed) {
        this.ed = ed;
    }

    public void addObjectStatusListener(ObjectStatusListener l) {
        this.listeners.add((Object)l);
    }

    public void removeObjectStatusListener(ObjectStatusListener l) {
        this.listeners.remove((Object)l);
    }

    public void update() {
        EntityChange change;
        this.changeSet.clear();
        this.toRemove.clear();
        while ((change = this.changes.poll()) != null) {
            EntityComponent value = change.getComponent();
            if (log.isTraceEnabled()) {
                log.trace("change:" + change);
            }
            EntityId id = change.getEntityId();
            if (value instanceof SpawnPosition && this.skip.remove(id)) continue;
            HoldingEntity entity = this.changeSet.get(id);
            if (entity == null) {
                entity = new HoldingEntity(id, this.types);
                this.changeSet.put(id, entity);
            }
            if (value == null) {
                if (log.isTraceEnabled()) {
                    log.trace(id + " value removed:" + change.getComponentType());
                }
                this.toRemove.add(change.getEntityId());
                entity.clear(change.getComponentType());
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace(id + ".set:" + value);
            }
            entity.set(value);
        }
        for (EntityId id : this.toRemove) {
            if (log.isTraceEnabled()) {
                log.trace("toRemove:" + id);
            }
            if (this.loaded.remove(id)) {
                this.objectRemoved(id);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("already removed:" + id);
        }
        for (HoldingEntity e : this.changeSet.values()) {
            if (!e.loadMissing()) continue;
            if (log.isTraceEnabled()) {
                log.trace("discovered entity:" + e.getId());
            }
            if (this.loaded.add(e.getId())) {
                this.objectAdded((Entity)e);
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace("already added:" + e.getId());
            }
            this.objectUpdated((Entity)e);
        }
    }

    public void initialize(BinIndex<EntityId, S> binIndex) {
        this.binIndex = binIndex;
        log.debug("initialize()");
        ((ObservableEntityData)this.ed).addEntityComponentListener((EntityComponentListener)this.entityListener);
    }

    public void tempActivate(Vec3d location) {
        log.debug("tempActivate(" + location + ")");
        Bin bin = this.binIndex.getBin(location, true);
    }

    protected boolean isStatic(Mass mass) {
        return mass.getMass() == 0.0;
    }

    public void loaded(Bin<EntityId, S> bin) {
        log.debug("loaded(" + bin + ")");
        Vec3i cell = bin.getGridCell().getCell();
        long binId = bin.getGridCell().getGrid().cellToId(cell.x, cell.y, cell.z);
        ComponentFilter filter = Filters.fieldEquals(SpawnPosition.class, (String)"binId", (Object)binId);
        for (EntityId id : this.ed.findEntities(filter, new Class[]{SpawnPosition.class, ShapeInfo.class, Mass.class})) {
            StaticBody body;
            log.debug("found:" + id);
            if (!this.loaded.add(id)) {
                log.debug("it's already loaded:" + id);
                continue;
            }
            Mass mass = (Mass)this.ed.getComponent(id, Mass.class);
            if (this.isStatic(mass)) {
                body = bin.addStaticBody((Object)id);
                this.fireStaticObjectLoaded(id, body);
                continue;
            }
            body = bin.addRigidBody((Object)id);
            this.fireObjectLoaded(id, (RigidBody<EntityId, S>)body);
        }
    }

    public void statusChanged(Bin<EntityId, S> bin, Bin.Status status) {
        log.debug("statusChanged(" + bin + "):" + status);
    }

    public void unloaded(Bin<EntityId, S> bin) {
        log.debug("unloaded(" + bin + ")");
        for (RigidBody body : (RigidBody[])bin.getActiveObjects().getArray()) {
            if (!log.isTraceEnabled()) continue;
            log.trace("  active:" + body);
        }
        for (RigidBody body : (RigidBody[])bin.getInactiveObjects().getArray()) {
            if (log.isTraceEnabled()) {
                log.trace("  inactive:" + body);
            }
            if (!this.loaded.remove(body.id)) {
                if (!log.isTraceEnabled()) continue;
                log.trace("it's already unloaded:" + body.id);
                continue;
            }
            Vec3d world = body.shape.getWorldShapeOrigin((AbstractBody)body);
            if (log.isTraceEnabled()) {
                log.trace(body.id + " set spawn position:" + world);
            }
            this.ed.setComponent((EntityId)body.id, (EntityComponent)new SpawnPosition(this.binIndex.getGrid(), world, body.orientation));
            this.skip.add((EntityId)body.id);
            this.fireObjectUnloaded((EntityId)body.id, body);
        }
        for (StaticBody body : bin.getStaticObjects()) {
            if (log.isTraceEnabled()) {
                log.trace("  static:" + body);
            }
            if (!this.loaded.remove(body.id)) {
                if (!log.isTraceEnabled()) continue;
                log.trace("it's already unloaded:" + body.id);
                continue;
            }
            this.fireStaticObjectUnloaded((EntityId)body.id, body);
        }
    }

    public void terminate(BinIndex<EntityId, S> binIndex) {
        log.debug("terminate()");
        ((ObservableEntityData)this.ed).removeEntityComponentListener((EntityComponentListener)this.entityListener);
        this.binIndex = null;
    }

    protected void objectRemoved(EntityId id) {
        if (log.isTraceEnabled()) {
            log.trace("objectRemoved(" + id + ")");
        }
        log.info("objectRemoved(" + id + ")");
        this.skip.remove(id);
        AbstractBody body = this.binIndex.remove((Object)id);
        if (log.isTraceEnabled()) {
            log.trace("removed object:" + body);
        }
        if (body instanceof RigidBody) {
            this.fireObjectUnloaded(id, (RigidBody)body);
        } else if (body instanceof StaticBody) {
            this.fireStaticObjectUnloaded(id, (StaticBody)body);
        }
    }

    protected void objectAdded(Entity entity) {
        if (this.skip.remove(entity.getId())) {
            if (log.isTraceEnabled()) {
                log.trace("Skipping:" + entity.getId());
            }
            return;
        }
        Mass mass = (Mass)entity.get(Mass.class);
        EntityId id = entity.getId();
        if (this.isStatic(mass)) {
            StaticBody sb = this.binIndex.addStaticBody((Object)id);
            this.fireStaticObjectLoaded(id, sb);
        } else {
            RigidBody body = this.binIndex.addRigidBody((Object)id);
            this.fireObjectLoaded(id, body);
        }
    }

    protected void objectUpdated(Entity entity) {
        Mass mass;
        if (log.isTraceEnabled()) {
            log.trace("objectUpdated(" + entity.getId() + ")");
        }
        if (this.isStatic(mass = (Mass)entity.get(Mass.class))) {
            this.staticBodyUpdated(entity, this.binIndex.getStaticBody((Object)entity.getId()));
        } else {
            this.rigidBodyUpdated(entity, this.binIndex.getRigidBody((Object)entity.getId()));
        }
    }

    protected void staticBodyUpdated(Entity entity, StaticBody<EntityId, S> sb) {
        EntityId id = entity.getId();
        if (log.isTraceEnabled()) {
            log.trace("staticBodyUpdated(" + id + ")");
        }
        if (sb == null) {
            AbstractBody removed;
            RigidBody rb = this.binIndex.getRigidBody((Object)id);
            if (rb == null) {
                log.warn("Update for entity:" + id + " but no static or rigid body exists.");
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("**** Dynamic to static:" + id);
            }
            if ((removed = this.binIndex.remove((Object)id)) != rb) {
                log.warn("Thought we were removing:" + rb + " but actually removed:" + removed);
            }
            Vec3d world = rb.shape.getWorldShapeOrigin((AbstractBody)rb);
            if (log.isTraceEnabled()) {
                log.trace(id + " setting spawn position to:" + world + ", " + rb.orientation);
            }
            this.ed.setComponent(id, (EntityComponent)new SpawnPosition(this.binIndex.getGrid(), world, rb.orientation));
            this.skip.add(id);
            this.fireObjectUnloaded(id, rb);
            sb = this.binIndex.addStaticBody((Object)id);
            this.fireStaticObjectLoaded(id, sb);
        } else {
            SpawnPosition pos = (SpawnPosition)entity.get(SpawnPosition.class);
            if (pos != null) {
                sb.shape.setWorldShapeOrigin(sb, pos.getLocation(), pos.getOrientation());
            }
        }
    }

    protected void rigidBodyUpdated(Entity entity, RigidBody<EntityId, S> rb) {
        EntityId id = entity.getId();
        if (log.isTraceEnabled()) {
            log.trace("rigidBodyUpdated(" + id + ")");
        }
        if (rb == null) {
            AbstractBody removed;
            StaticBody sb = this.binIndex.getStaticBody((Object)id);
            if (sb == null) {
                log.warn("Update for entity:" + id + " but no rigid or static body exists.");
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("**** Static to dynamic:" + id);
            }
            if ((removed = this.binIndex.remove((Object)id)) != sb) {
                log.warn("Thought we were removing:" + sb + " but actually removed:" + removed);
            }
            this.fireStaticObjectUnloaded(id, sb);
            rb = this.binIndex.addRigidBody((Object)id);
            this.fireObjectLoaded(id, rb);
        }
    }

    protected final void fireObjectLoaded(EntityId id, RigidBody<EntityId, S> body) {
        if (log.isTraceEnabled()) {
            log.trace("fireObjectLoaded(" + id + ")");
        }
        for (ObjectStatusListener l : (ObjectStatusListener[])this.listeners.getArray()) {
            l.objectLoaded(id, body);
        }
    }

    protected final void fireObjectUnloaded(EntityId id, RigidBody<EntityId, S> body) {
        if (log.isTraceEnabled()) {
            log.trace("fireObjectUnloaded(" + id + ")");
        }
        for (ObjectStatusListener l : (ObjectStatusListener[])this.listeners.getArray()) {
            l.objectUnloaded(id, body);
        }
    }

    protected final void fireStaticObjectLoaded(EntityId id, StaticBody<EntityId, S> body) {
        if (log.isTraceEnabled()) {
            log.trace("fireStaticObjectLoaded(" + id + ")");
        }
        for (ObjectStatusListener l : (ObjectStatusListener[])this.listeners.getArray()) {
            l.staticObjectLoaded(id, body);
        }
    }

    protected final void fireStaticObjectUnloaded(EntityId id, StaticBody<EntityId, S> body) {
        if (log.isTraceEnabled()) {
            log.trace("fireStaticObjectUnloaded(" + id + ")");
        }
        for (ObjectStatusListener l : (ObjectStatusListener[])this.listeners.getArray()) {
            l.staticObjectUnloaded(id, body);
        }
    }

    private class HoldingEntity
    extends DefaultEntity {
        public HoldingEntity(EntityId id, Class[] types) {
            super(null, id, new EntityComponent[types.length], types);
        }

        public void set(EntityComponent c) {
            EntityComponent[] components = this.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!BinEntityManager.this.types[i].isInstance(c)) continue;
                components[i] = c;
                return;
            }
        }

        public void clear(Class type) {
            EntityComponent[] components = this.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (BinEntityManager.this.types[i] != type) continue;
                components[i] = null;
                return;
            }
        }

        public boolean loadMissing() {
            EntityComponent[] components = this.getComponents();
            int completed = 0;
            for (int i = 0; i < BinEntityManager.this.types.length; ++i) {
                if (components[i] == null) {
                    components[i] = BinEntityManager.this.ed.getComponent(this.getId(), BinEntityManager.this.types[i]);
                    if (components[i] == null) continue;
                    ++completed;
                    continue;
                }
                ++completed;
            }
            return completed == BinEntityManager.this.types.length;
        }
    }

    private class EntityChangeObserver
    implements EntityComponentListener {
        private EntityChangeObserver() {
        }

        public void componentChange(EntityChange change) {
            Class type = change.getComponentType();
            if (type != SpawnPosition.class && type != ShapeInfo.class && type != Mass.class) {
                return;
            }
            BinEntityManager.this.changes.add(change);
        }
    }
}

