/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.gext;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.util.List;
import org.codehaus.groovy.runtime.typehandling.GroovyCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuatdGroovyMethods {
    static Logger log = LoggerFactory.getLogger(QuatdGroovyMethods.class);

    public static Quatd plus(Quatd q1, Quatd q2) {
        return q1.add(q2);
    }

    public static Quatd plus(Quatd q1, List<Number> q2) {
        if (q2.isEmpty()) {
            return q1;
        }
        double x = q2.get(0).doubleValue();
        double y = q2.size() > 1 ? q2.get(1).doubleValue() : 0.0;
        double z = q2.size() > 2 ? q2.get(2).doubleValue() : 0.0;
        double w = q2.size() > 3 ? q2.get(3).doubleValue() : 0.0;
        return q1.add(new Quatd(x, y, z, w));
    }

    public static Quatd minus(Quatd q1, Quatd q2) {
        return q1.subtract(q2);
    }

    public static Quatd minus(Quatd q1, List<Number> q2) {
        if (q2.isEmpty()) {
            return q1;
        }
        double x = q2.get(0).doubleValue();
        double y = q2.size() > 1 ? q2.get(1).doubleValue() : 0.0;
        double z = q2.size() > 2 ? q2.get(2).doubleValue() : 0.0;
        double w = q2.size() > 3 ? q2.get(3).doubleValue() : 0.0;
        return q1.subtract(new Quatd(x, y, z, w));
    }

    public static Quatd multiply(Quatd q1, Quatd q2) {
        return q1.mult(q2);
    }

    public static Object multiply(Quatd q1, List<Number> q2) {
        if (q2.size() == 3) {
            double x = q2.get(0).doubleValue();
            double y = q2.get(1).doubleValue();
            double z = q2.get(2).doubleValue();
            return q1.mult(new Vec3d(x, y, z));
        }
        if (q2.size() == 4) {
            double x = q2.get(0).doubleValue();
            double y = q2.get(1).doubleValue();
            double z = q2.get(2).doubleValue();
            double w = q2.get(3).doubleValue();
            return q1.mult(new Quatd(x, y, z, w));
        }
        throw new GroovyCastException("Cannot convert:" + q2 + " to a Vec3d or a Quatd.");
    }

    public static Vec3d multiply(Quatd q, Vec3d v) {
        return q.mult(v);
    }

    public static Vec3d multiply(Quatd q, Vec3i v) {
        return q.mult(v.toVec3d());
    }

    public static Object asType(Quatd v, Class type) {
        if (type == Quatd.class) {
            return v;
        }
        throw new GroovyCastException("Cannot convert:" + v + " to:" + type);
    }
}

