/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mblock;

import com.google.common.reflect.TypeToken;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.DynArray;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockShapeFactory
implements ShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(BlockShapeFactory.class);
    private DynArray<Function<String, CellArray>> delegates = new DynArray((TypeToken)new TypeToken<Function<String, CellArray>>(){});

    public void addDelegate(Function<String, CellArray> delegate) {
        this.delegates.add(delegate);
    }

    public List<Function<String, CellArray>> getDelegates() {
        return this.delegates;
    }

    public MBlockShape createShape(String name, double scale, Mass mass) {
        if (log.isTraceEnabled()) {
            log.trace("createShape(" + name + ", " + scale + ", " + mass + ")");
        }
        double m = mass == null ? 0.0 : mass.getMass();
        CellArray cells = this.loadCells(name);
        if (cells == null) {
            return null;
        }
        return MBlockShape.createShape((String)name, (CellArray)cells, (double)scale, (double)m);
    }

    protected CellArray loadCells(String name) {
        for (Function f : (Function[])this.delegates.getArray()) {
            CellArray result = (CellArray)f.apply(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

