/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.simsilica.es.sql.SqlSession;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTable {
    static Logger log = LoggerFactory.getLogger(StringTable.class);
    private String tableName = "STRINGS";
    private int maxIndexedStringSize;
    private boolean cached = true;
    private String insertSql;
    private String idForString;
    private String stringForId;

    protected StringTable(int maxIndexedStringSize) {
        this.maxIndexedStringSize = maxIndexedStringSize;
        this.idForString = "select id from STRINGS where val=?";
        this.stringForId = "select val from STRINGS where id=?";
        this.insertSql = "insert into " + this.tableName + " (id,val) values (default,?)";
    }

    public static StringTable create(SqlSession session, int maxIndexedStringSize) throws SQLException {
        StringTable result = new StringTable(maxIndexedStringSize);
        result.initialize(session);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(SqlSession session) throws SQLException {
        DatabaseMetaData md = session.getConnection().getMetaData();
        log.info("Checking for table:" + this.tableName);
        HashMap<String, ColumnInfo> dbFields = new HashMap<String, ColumnInfo>();
        try (ResultSet rs = md.getColumns(null, "PUBLIC", this.tableName, null);){
            while (rs.next()) {
                dbFields.put(rs.getString("COLUMN_NAME"), new ColumnInfo(rs));
            }
        }
        log.info("dbFields for " + this.tableName + " :" + dbFields);
        if (!dbFields.isEmpty()) {
            this.checkStructure(session, dbFields);
            return;
        }
        StringBuilder sb = new StringBuilder("CREATE");
        if (this.cached) {
            sb.append(" CACHED");
        }
        sb.append(" TABLE");
        sb.append(" " + this.tableName + "\n");
        sb.append("(\n");
        sb.append("  id INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY");
        sb.append(",\n  val VARCHAR(" + this.maxIndexedStringSize + ")");
        sb.append(",\n  CONSTRAINT val_key UNIQUE (val)");
        sb.append("\n)");
        if (log.isTraceEnabled()) {
            log.trace("Create statement:\n" + sb);
        }
        Statement st = session.getConnection().createStatement();
        int i = st.executeUpdate(sb.toString());
        st.close();
        if (log.isTraceEnabled()) {
            log.trace("Result:" + i);
        }
    }

    protected void checkStructure(SqlSession session, Map<String, ColumnInfo> dbFields) throws SQLException {
        ColumnInfo val = dbFields.get("VAL");
        if (val != null && val.size < this.maxIndexedStringSize) {
            this.upgradeValueSize(session, val.size, this.maxIndexedStringSize);
        }
    }

    protected void upgradeValueSize(SqlSession session, int from, int to) throws SQLException {
        log.warn("************************************");
        log.warn("***** UPGRADING StringIndex table value size from:" + from + " to:" + to);
        log.warn("************************************");
        String sql = "ALTER TABLE " + this.tableName + " ALTER COLUMN VAL VARCHAR(" + to + ")";
        log.info("Running:" + sql);
        Statement st = session.getConnection().createStatement();
        int i = st.executeUpdate(sql);
        st.close();
        log.info("result:" + i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int lookupString(SqlSession session, String s) throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace("executing query:" + this.idForString);
        }
        PreparedStatement st = session.prepareStatement(this.idForString);
        st.setObject(1, s);
        try (ResultSet rs = st.executeQuery();){
            if (rs.next()) {
                Integer i = (Integer)rs.getObject(1);
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    protected int addString(SqlSession session, String s) throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace("Executing:" + this.insertSql);
        }
        PreparedStatement st = session.prepareStatement(this.insertSql, 1);
        st.setObject(1, s);
        int count = st.executeUpdate();
        if (log.isTraceEnabled()) {
            log.trace("count:" + count);
        }
        try (ResultSet keys = st.getGeneratedKeys();){
            if (keys.next()) {
                Integer i = (Integer)keys.getObject(1);
                if (log.isTraceEnabled()) {
                    log.trace("Generated key: " + i);
                }
                int n = i;
                return n;
            }
            throw new RuntimeException("Failed to add string:" + s);
        }
    }

    public int getStringId(SqlSession session, String s, boolean add) throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace("db.getStringId(" + s + ", " + add + ")");
        }
        int result = this.lookupString(session, s);
        if (log.isTraceEnabled()) {
            log.trace("Result from lookup:" + result);
        }
        if (result == -1 && add) {
            result = this.addString(session, s);
            if (log.isTraceEnabled()) {
                log.trace("result from add:" + result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(SqlSession session, int id) throws SQLException {
        PreparedStatement st = session.prepareStatement(this.stringForId);
        st.setObject(1, id);
        try (ResultSet rs = st.executeQuery();){
            if (rs.next()) {
                String s;
                String string = s = (String)rs.getObject(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private class ColumnInfo {
        int type;
        int size;

        public ColumnInfo(ResultSet rs) throws SQLException {
            this.type = rs.getInt("DATA_TYPE");
            this.size = rs.getInt("COLUMN_SIZE");
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[type:" + this.type + ", size:" + this.size + "]";
        }
    }
}

