/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.KinematicInfo;
import com.simsilica.mphys.BodyMass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Part {
    static Logger log = LoggerFactory.getLogger(Part.class);
    protected static final int REFRESH_MASS = 1;
    protected static final int REFRESH_TRANSFORM = 2;
    protected static final int REFRESH_REL_COG = 4;
    private int refreshFlags = 0;
    private long version;
    private String name;
    private Group parent;
    private BodyMass mass;
    private Vec3d localPosition = new Vec3d();
    private Quatd localOrientation = new Quatd();
    private Vec3d shapeRelPosition = new Vec3d();
    private Quatd shapeRelOrientation = new Quatd();
    private Vec3d shapeRelCog = new Vec3d();
    private KinematicInfo kinInfo;

    protected Part(String name) {
        this.name = name;
    }

    public long getVersion() {
        return this.version;
    }

    public void setKinematicInfo(KinematicInfo kinInfo) {
        this.kinInfo = kinInfo;
        kinInfo.initialize(this.getShapeRelativePosition(), this.getShapeRelativeOrientation());
    }

    public void updateKinematicInfo() {
        if (this.kinInfo != null) {
            this.kinInfo.update(this.getShapeRelativePosition(), this.getShapeRelativeOrientation());
        }
    }

    public KinematicInfo getKinematicInfo() {
        return this.kinInfo;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected int getRefreshFlags() {
        return this.refreshFlags;
    }

    public void setLocalPosition(Vec3d pos) {
        this.localPosition.set(pos);
        this.markForRefresh(2);
        this.markForRefresh(4);
        if (this.parent != null) {
            this.parent.markForRefresh(1);
        }
    }

    public Vec3d getLocalPosition() {
        return this.localPosition;
    }

    public void setLocalOrientation(Quatd orient) {
        this.localOrientation.set(orient);
        this.markForRefresh(2);
        this.markForRefresh(4);
        if (this.parent != null) {
            this.parent.markForRefresh(1);
        }
    }

    public Quatd getLocalOrientation() {
        return this.localOrientation;
    }

    protected void updateTransform() {
        if (this.parent == null) {
            this.shapeRelPosition.set(this.localPosition);
            this.shapeRelOrientation.set(this.localOrientation);
        } else {
            Quatd refOrient = this.parent.getShapeRelativeOrientation();
            refOrient.mult(this.localPosition, this.shapeRelPosition);
            this.shapeRelPosition.addLocal(this.parent.getShapeRelativePosition());
            this.shapeRelOrientation.set(refOrient).multLocal(this.localOrientation);
        }
        this.clearRefreshNeeded(2);
    }

    protected abstract void updateMass();

    protected void updateCog() {
        this.getShapeRelativeOrientation().mult(this.getMass().getCog(), this.shapeRelCog);
        this.shapeRelCog.addLocal(this.getShapeRelativePosition());
        this.clearRefreshNeeded(4);
    }

    public Vec3d getShapeRelativePosition() {
        if (this.isRefreshNeeded(2)) {
            this.updateTransform();
        }
        return this.shapeRelPosition;
    }

    public Quatd getShapeRelativeOrientation() {
        if (this.isRefreshNeeded(2)) {
            this.updateTransform();
        }
        return this.shapeRelOrientation;
    }

    public Vec3d getShapeRelativeCog() {
        if (this.isRefreshNeeded(4)) {
            this.updateCog();
        }
        return this.shapeRelCog;
    }

    protected boolean isRefreshNeeded(int flag) {
        return (this.refreshFlags & flag) != 0;
    }

    protected void markForRefresh(int flag) {
        if ((this.refreshFlags & 1) == 0 && flag == 1) {
            ++this.version;
        }
        this.refreshFlags |= flag;
        if (this.parent != null && (flag & 1) != 0) {
            this.parent.markForRefresh(flag);
        }
    }

    protected void clearRefreshNeeded(int flag) {
        this.refreshFlags &= ~flag;
    }

    protected void setParent(Group parent) {
        if (this.parent == parent) {
            return;
        }
        this.parent = parent;
        this.markForRefresh(2);
        this.markForRefresh(4);
        if (parent != null) {
            parent.markForRefresh(1);
        }
    }

    public Group getParent() {
        return this.parent;
    }

    protected void setMass(BodyMass mass) {
        this.mass = mass;
        this.clearRefreshNeeded(1);
        this.markForRefresh(4);
    }

    public BodyMass getMass() {
        if (this.mass == null || this.isRefreshNeeded(1)) {
            this.updateMass();
        }
        return this.mass;
    }

    public abstract Part[] traverse();

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("name", (Object)this.name).add("bodyMass", (Object)this.mass).toString();
    }
}

