/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.client;

import com.simsilica.es.StringIndex;
import com.simsilica.es.client.RemoteEntityData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RemoteStringIndex
implements StringIndex {
    private RemoteEntityData remote;
    private Map<String, Integer> idIndex = new ConcurrentHashMap<String, Integer>();
    private Map<Integer, String> stringIndex = new ConcurrentHashMap<Integer, String>();
    private ReadWriteLock indexLock = new ReentrantReadWriteLock();

    protected RemoteStringIndex(RemoteEntityData remote) {
        this.remote = remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStringId(String s, boolean add) {
        Integer result;
        if (add) {
            throw new UnsupportedOperationException("Clients cannot create new string mappings.");
        }
        this.indexLock.readLock().lock();
        try {
            result = this.idIndex.get(s);
            if (result != null) {
                int n = result;
                return n;
            }
        }
        finally {
            this.indexLock.readLock().unlock();
        }
        this.indexLock.writeLock().lock();
        try {
            result = this.idIndex.get(s);
            if (result != null) {
                int n = result;
                return n;
            }
            result = this.remote.getStringId(s);
            if (result >= 0) {
                this.idIndex.put(s, result);
                this.stringIndex.put(result, s);
                int n = result;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int id) {
        String result;
        this.indexLock.readLock().lock();
        try {
            result = this.stringIndex.get(id);
            if (result != null) {
                String string = result;
                return string;
            }
        }
        finally {
            this.indexLock.readLock().unlock();
        }
        this.indexLock.writeLock().lock();
        try {
            result = this.stringIndex.get(id);
            if (result != null) {
                String string = result;
                return string;
            }
            result = this.remote.getString(id);
            if (result != null) {
                this.idIndex.put(result, id);
                this.stringIndex.put(id, result);
            }
            String string = result;
            return string;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }
}

