/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.reflect.TypeToken;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Bin;
import com.simsilica.mphys.BinListener;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.Joint;
import com.simsilica.mphys.PhysicsFactory;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinIndex<K, S extends AbstractShape> {
    static Logger log = LoggerFactory.getLogger(BinIndex.class);
    private final Grid grid;
    private final Vec3i gridRadius;
    private final Map<GridCell, Bin<K, S>> bins = new HashMap<GridCell, Bin<K, S>>();
    private final DynArray<Bin<K, S>> activeBins = new DynArray(new TypeToken<Bin<K, S>>(){});
    private Set<Bin<K, S>> pendingUnload = new HashSet<Bin<K, S>>();
    private Map<Bin<K, S>, Neighborhood> neighborhoods = new HashMap<Bin<K, S>, Neighborhood>();
    private final DynArray<BinListener<K, S>> binListeners = new DynArray(new TypeToken<BinListener<K, S>>(){});
    private PhysicsFactory<K, S> factory;
    private Map<K, RigidBodyEntry> rigidBodies = new HashMap<K, RigidBodyEntry>();
    private Map<K, StaticBody<K, S>> staticBodies = new HashMap<K, StaticBody<K, S>>();
    private Map<K, Joint<K, S>> jointIndex = new HashMap<K, Joint<K, S>>();
    private ListMultimap<RigidBody<K, S>, Joint<K, S>> bodyJoints = ArrayListMultimap.create();
    private final DynArray<Joint<K, S>> activeJoints = new DynArray(new TypeToken<Joint<K, S>>(){});

    public BinIndex(Grid grid) {
        this(grid, null);
    }

    public BinIndex(Grid grid, Vec3i gridRadius) {
        this.grid = grid;
        if (gridRadius != null) {
            this.gridRadius = gridRadius;
        } else {
            int xd = grid.getSpacing().x != 0 ? 1 : 0;
            int yd = grid.getSpacing().y != 0 ? 1 : 0;
            int zd = grid.getSpacing().z != 0 ? 1 : 0;
            this.gridRadius = new Vec3i(xd, yd, zd);
        }
    }

    public Set<K> getBodyIds() {
        return this.rigidBodies.keySet();
    }

    public Set<K> getStaticBodyIds() {
        return this.staticBodies.keySet();
    }

    public void writeDebugInfo(PrintWriter out) {
        out.println("Total bin count:" + this.bins.size());
        for (Map.Entry<GridCell, Bin<K, S>> entry : this.bins.entrySet()) {
            entry.getValue().writeDebugInfo(out);
            if (!this.pendingUnload.contains(entry.getValue())) continue;
            out.println("  ** pending unload **");
        }
        out.println("----------------------------");
        out.println("Rigid body entries:");
        for (RigidBodyEntry rigidBodyEntry : this.rigidBodies.values()) {
            out.println("    " + rigidBodyEntry);
        }
    }

    public final int size() {
        return this.bins.size();
    }

    public final int getActiveBinCount() {
        return this.neighborhoods.size();
    }

    public final int getActiveJointCount() {
        if (this.activeJoints.size() != this.jointIndex.size()) {
            log.warn("active joints:" + this.activeJoints.size() + "  joints:" + this.jointIndex.size());
        }
        return this.activeJoints.size();
    }

    public final int getRigidBodyCount() {
        return this.rigidBodies.size();
    }

    public Grid getGrid() {
        return this.grid;
    }

    public Vec3i getGridRadius() {
        return this.gridRadius;
    }

    public void setPhysicsFactory(PhysicsFactory<K, S> factory) {
        this.factory = factory;
    }

    public PhysicsFactory<K, S> getPhysicsFactory() {
        return this.factory;
    }

    public void addBinListener(BinListener<K, S> l) {
        l.initialize(this);
        this.binListeners.add(l);
    }

    public void removeBinListener(BinListener<K, S> l) {
        this.binListeners.remove(l);
        l.terminate(this);
    }

    protected void fireBinLoaded(Bin<K, S> bin) {
        for (BinListener<K, S> l : this.binListeners.getArray()) {
            l.loaded(bin);
        }
    }

    protected void fireBinStatusChanged(Bin<K, S> bin, Bin.Status status) {
        for (BinListener<K, S> l : this.binListeners.getArray()) {
            l.statusChanged(bin, status);
        }
    }

    protected void fireBinUnloaded(Bin<K, S> bin) {
        for (BinListener<K, S> l : this.binListeners.getArray()) {
            l.unloaded(bin);
        }
    }

    public void activate(Vec3d location) {
        GridCell cell = this.grid.getContainingCell(location);
        this.activate(cell);
    }

    public void activate(GridCell cell) {
        this.getBin(cell, true);
    }

    public void activate(RigidBody<K, S> body) {
        if (log.isTraceEnabled()) {
            log.trace("activate(" + body.id + ") bin:" + this.getBin(body));
        }
        RigidBodyEntry entry = this.getRigidBodyEntry(body.id, false);
        entry.setActive(true);
    }

    public void deactivate(RigidBody<K, S> body) {
        if (log.isTraceEnabled()) {
            log.trace("deactivate(" + body.id + ") bin:" + this.getBin(body));
        }
        RigidBodyEntry entry = this.getRigidBodyEntry(body.id, false);
        entry.setActive(false);
    }

    public RigidBody<K, S> getRigidBody(K id) {
        RigidBodyEntry entry = this.getRigidBodyEntry(id, false);
        return entry == null ? null : entry.body;
    }

    public StaticBody<K, S> getStaticBody(K id) {
        return this.staticBodies.get(id);
    }

    public RigidBody<K, S> addRigidBody(K id) {
        RigidBodyEntry entry = this.getRigidBodyEntry(id, true);
        return entry.body;
    }

    public StaticBody<K, S> addStaticBody(K id) {
        StaticBody<K, S> body = this.getStaticBody(id, true);
        Bin<K, S> bin = this.getBin(body.position, true);
        bin.add(body);
        return body;
    }

    public AbstractBody<K, S> remove(K bodyId) {
        if (log.isTraceEnabled()) {
            log.trace("remove(" + bodyId + ")");
        }
        RigidBodyEntry entry = this.rigidBodies.remove(bodyId);
        log.info("remove(" + bodyId + ") hasRigidBody:" + (entry != null));
        if (entry != null) {
            entry.release();
            this.removeJoints(entry.body);
            return entry.body;
        }
        StaticBody<K, S> sb = this.staticBodies.remove(bodyId);
        if (sb == null) {
            if (log.isTraceEnabled()) {
                log.trace("No entry or static object exists for:" + bodyId);
            }
            return null;
        }
        Bin<K, S> bin = this.getBin(sb.position, false);
        if (bin != null) {
            bin.remove(sb);
        } else {
            log.error("Removed stale static body from the master index:" + bodyId);
        }
        return sb;
    }

    public boolean teleport(K id, Vec3d loc, Quatd orient) {
        RigidBodyEntry entry = this.getRigidBodyEntry(id, false);
        if (entry == null) {
            return false;
        }
        entry.body.teleport(loc, orient);
        entry.update();
        entry.setActive(true);
        return true;
    }

    public boolean morph(K id, S shape) {
        RigidBodyEntry entry = this.getRigidBodyEntry(id, false);
        if (entry == null) {
            return false;
        }
        entry.body.morph(shape);
        return true;
    }

    public void update(RigidBody<K, S> body) {
        RigidBodyEntry entry = this.getRigidBodyEntry(body.id, false);
        entry.update();
    }

    public boolean applyImpulse(K id, Vec3d impulse) {
        RigidBodyEntry entry = this.getRigidBodyEntry(id, true);
        if (entry == null) {
            return false;
        }
        entry.body.addLinearVelocity(impulse);
        entry.setActive(true);
        return true;
    }

    public Bin<K, S>[] getActiveBins() {
        return this.activeBins.getArray();
    }

    public DynArray<Joint<K, S>> getActiveJoints() {
        return this.activeJoints;
    }

    public Bin<K, S> getBin(Vec3d location, boolean create) {
        GridCell cell = this.grid.getContainingCell(location);
        return this.getBin(cell, create);
    }

    public Bin<K, S> getBin(GridCell cell, boolean create) {
        Bin<K, S> result = this.bins.get(cell);
        if (result == null && create) {
            result = new Bin(this, cell);
            this.bins.put(cell, result);
            this.fireBinLoaded(result);
            this.markForUnload(result);
        }
        return result;
    }

    public Bin<K, S> getBin(RigidBody<K, S> body) {
        RigidBodyEntry entry = this.getRigidBodyEntry(body.id, false);
        return entry.bin;
    }

    public Bin<K, S>[] getNeighbors(Bin<K, S> bin) {
        Neighborhood n = this.neighborhoods.get(bin);
        if (n == null) {
            return null;
        }
        return n.neighbors;
    }

    protected void activate(Bin<K, S> bin) {
        Neighborhood n = this.neighborhoods.get(bin);
        if (n != null) {
            throw new RuntimeException("*** How did this happen?");
        }
        n = new Neighborhood(bin);
        this.neighborhoods.put(bin, n);
        n.acquire();
        this.activeBins.add(bin);
    }

    protected void deactivate(Bin<K, S> bin) {
        Neighborhood n = this.neighborhoods.remove(bin);
        if (n == null) {
            throw new RuntimeException("*** How did this happen?");
        }
        n.release();
        this.activeBins.remove(bin);
    }

    protected void markForUnload(Bin<K, S> bin) {
        if (log.isTraceEnabled()) {
            log.trace("marked for unloading:" + bin);
        }
        this.pendingUnload.add(bin);
    }

    private void unload(Bin<K, S> bin) {
        Bin<K, S> removed = this.bins.remove(bin.getGridCell());
        if (log.isTraceEnabled()) {
            log.trace("unloading:" + removed);
        }
        for (RigidBody<K, S> rigidBody : bin.getActiveObjects()) {
            this.unloadRigidBody(rigidBody.id);
        }
        for (RigidBody<K, S> rigidBody : bin.getInactiveObjects()) {
            this.unloadRigidBody(rigidBody.id);
        }
        for (StaticBody staticBody : bin.getStaticObjects()) {
            this.unloadStaticBody(staticBody.id);
        }
        this.fireBinUnloaded(bin);
    }

    public final void flushPending() {
        if (log.isTraceEnabled()) {
            log.trace("flushPending()");
        }
        if (this.pendingUnload.isEmpty()) {
            return;
        }
        for (Bin<K, S> bin : this.pendingUnload) {
            if (log.isTraceEnabled()) {
                log.trace("Checking bin:" + bin + "  watchersCount:" + bin.getWatchersCount() + "  status:" + (Object)((Object)bin.getStatus()));
            }
            if (bin.getWatchersCount() != 0 || bin.getStatus() == Bin.Status.Active) continue;
            this.unload(bin);
        }
        this.pendingUnload.clear();
    }

    private Bin<K, S>[] findNeighbors(Bin<K, S> bin) {
        int xd = this.gridRadius.x;
        int yd = this.gridRadius.y;
        int zd = this.gridRadius.z;
        int size = (xd * 2 + 1) * (yd * 2 + 1) * (zd * 2 + 1);
        Bin[] neighbors = new Bin[size - 1];
        int pos = 0;
        Vec3i cell = bin.getGridCell().getCell();
        for (int x = cell.x - xd; x <= cell.x + xd; ++x) {
            for (int y = cell.y - yd; y <= cell.y + yd; ++y) {
                for (int z = cell.z - zd; z <= cell.z + zd; ++z) {
                    if (cell.x == x && cell.y == y && cell.z == z) continue;
                    neighbors[pos++] = this.getBin(this.grid.getGridCell(x, y, z), true);
                }
            }
        }
        return neighbors;
    }

    protected RigidBody<K, S> addRigidBodyToBin(Bin<K, S> bin, K bodyId) {
        RigidBodyEntry entry = this.getRigidBodyEntry(bodyId, true);
        if (entry.bin != bin) {
            log.warn("Object " + bodyId + " is not in target bin:" + bin + " and has been rehomed to:" + entry.bin);
        }
        return entry.body;
    }

    protected StaticBody<K, S> addStaticBodyToBin(Bin<K, S> bin, K bodyId) {
        StaticBody<K, S> body = this.getStaticBody(bodyId, true);
        Bin<K, S> bodyBin = this.getBin(body.position, true);
        bodyBin.add(body);
        if (bodyBin != bin) {
            log.warn("Object " + bodyId + " is no in bin:" + bin + " to be added.  Adding it to the real bin:" + bodyBin);
        }
        return body;
    }

    protected RigidBodyEntry getRigidBodyEntry(K key, boolean create) {
        RigidBodyEntry result = this.rigidBodies.get(key);
        if (result == null && create) {
            if (log.isDebugEnabled()) {
                log.debug("Creating RigidBody for:" + key);
            }
            RigidBody<K, S> body = this.factory.createRigidBody(key);
            result = new RigidBodyEntry(body);
            this.rigidBodies.put(key, result);
        }
        return result;
    }

    protected void unloadRigidBody(K key) {
        RigidBodyEntry entry = this.rigidBodies.remove(key);
        this.removeJoints(entry.body);
    }

    protected void removeJoints(RigidBody<K, S> body) {
        for (Joint joint : this.bodyJoints.removeAll(body)) {
            this.jointIndex.remove(joint.getId());
            this.activeJoints.remove(joint);
            RigidBody<K, S> other = joint.getOtherBody(body);
            if (other == null) continue;
            this.bodyJoints.remove(other, (Object)joint);
        }
    }

    protected StaticBody<K, S> getStaticBody(K key, boolean create) {
        StaticBody<K, S> result = this.staticBodies.get(key);
        if (result == null && create) {
            result = this.factory.createStaticBody(key);
            this.staticBodies.put(key, result);
        }
        return result;
    }

    protected void unloadStaticBody(K key) {
        StaticBody<K, S> body = this.staticBodies.remove(key);
    }

    protected void addJointToBin(Bin<K, S> bin, K jointId, K bodyId1, K bodyId2) {
        Joint<K, S> joint;
        if (log.isDebugEnabled()) {
            log.debug("addJoint(" + bin + ", " + jointId + ", " + bodyId1 + ", " + bodyId2 + ")");
        }
        if ((joint = this.jointIndex.get(jointId)) != null) {
            log.debug("Joint already exists for:" + jointId);
            return;
        }
        if (bodyId2 != null) {
            RigidBodyEntry end1 = this.getRigidBodyEntry(bodyId1, true);
            RigidBodyEntry end2 = this.getRigidBodyEntry(bodyId2, true);
            log.debug("retrieved end1:" + end1 + "  end2:" + end2);
            joint = this.jointIndex.get(jointId);
            if (joint != null) {
                log.debug("Joint:" + jointId + " loaded by other bin.");
                return;
            }
            joint = this.factory.createJoint(jointId, end1.body, end2.body);
            log.debug("created joint:" + jointId);
            this.jointIndex.put(jointId, joint);
            this.activeJoints.add(joint);
            this.bodyJoints.put(end1.body, joint);
            this.bodyJoints.put(end2.body, joint);
        } else {
            RigidBodyEntry end1 = this.getRigidBodyEntry(bodyId1, true);
            log.debug("retrieved end1:" + end1);
            joint = this.jointIndex.get(jointId);
            if (joint != null) {
                log.warn("Single ended joint:" + jointId + " loaded by other bin.");
                return;
            }
            joint = this.factory.createJoint(jointId, end1.body, null);
            log.debug("created joint:" + jointId);
            this.jointIndex.put(jointId, joint);
            this.activeJoints.add(joint);
            this.bodyJoints.put(end1.body, joint);
        }
    }

    public void removeJointFromBin(Bin<K, S> bin, K jointId) {
        Joint<K, S> joint;
        if (log.isDebugEnabled()) {
            log.debug("removeJoint(" + bin + ", " + jointId + ")");
        }
        if ((joint = this.jointIndex.remove(jointId)) == null) {
            log.warn("No joint found for:" + jointId + " in removeJointFromBin()");
            return;
        }
        this.bodyJoints.remove(joint.getMainBody(), joint);
        this.activeJoints.remove(joint);
        if (joint.getAltBody() != null) {
            this.bodyJoints.remove(joint.getAltBody(), joint);
        }
    }

    protected class RigidBodyEntry {
        final RigidBody<K, S> body;
        Bin<K, S> bin;
        boolean active;

        public RigidBodyEntry(RigidBody<K, S> body) {
            this.body = body;
            this.active = !body.isSleepy();
            this.bin = BinIndex.this.getBin(body.position, true);
            if (log.isDebugEnabled()) {
                log.debug("Adding " + body.id + " to:" + this.bin);
            }
            this.bin.add(body, this.active);
        }

        public void setActive(boolean active) {
            if (this.active == active) {
                return;
            }
            this.active = active;
            if (active) {
                this.bin.activate(this.body);
            } else {
                this.bin.deactivate(this.body);
            }
        }

        public void update() {
            if (this.bin.contains(this.body.position)) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace(this.body.id + " is leaving " + this.bin);
            }
            this.bin.remove(this.body, this.active);
            this.bin = BinIndex.this.getBin(this.body.position, true);
            if (log.isTraceEnabled()) {
                log.trace(this.body.id + " is entering " + this.bin);
            }
            this.bin.add(this.body, this.active);
        }

        public void release() {
            this.bin.remove(this.body, this.active);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[body=" + this.body.id + ", bin=" + this.bin + ", active=" + this.active + "]";
        }
    }

    private class Neighborhood {
        Bin<K, S> bin;
        Bin<K, S>[] neighbors;

        public Neighborhood(Bin<K, S> bin) {
            this.bin = bin;
            this.neighbors = BinIndex.this.findNeighbors(bin);
        }

        protected void acquire() {
            for (Bin bin : this.neighbors) {
                bin.updateWatchersCount(1);
            }
        }

        protected void release() {
            for (Bin bin : this.neighbors) {
                bin.updateWatchersCount(-1);
            }
        }
    }
}

