/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.collision.ColliderFactories;
import com.simsilica.mblock.phys.collision.SimilarShapeIndex;
import java.util.function.Function;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaxBlocksFunction
implements Function<String, CellArray> {
    static Logger log = LoggerFactory.getLogger(FaxBlocksFunction.class);
    private SimilarShapeIndex shapeIndex;

    public FaxBlocksFunction() {
        BlockType[] types = BlockTypeIndex.getTypes();
        Collider[] colliders = new ColliderFactories(true).createColliders(types);
        this.shapeIndex = new SimilarShapeIndex(types, colliders);
    }

    @Override
    public CellArray apply(String name) {
        ShapeName shapeName = ShapeName.parse(name);
        if (!"fax".equals(shapeName.getType())) {
            return null;
        }
        String typeString = shapeName.getName();
        if (typeString.startsWith("c_")) {
            typeString = typeString.substring(2);
        }
        int type = Integer.parseInt(typeString);
        CellArray array = this.shapeIndex.createFacsimile(type);
        log.info("fax for:" + type + "  array:" + array);
        if (array == null) {
            array = new CellArray(4);
            array.clear(BlockTypeIndex.getBadTypeIndex());
        }
        return array;
    }
}

