/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.TileId;
import com.simsilica.progress.ProgressTracker;
import com.simsilica.progress.ProgressTrackers;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import mythruna.GameConstants;
import mythruna.es.MapMarker;
import mythruna.world.WorldFractal;
import mythruna.world.cave.CaveEdge;
import mythruna.world.cave.CaveGraph;
import mythruna.world.cave.CaveNetwork;
import mythruna.world.cave.CaveNode;
import mythruna.world.cave.Influencer;
import mythruna.world.cave.LineInfluencer;
import mythruna.world.cave.PointInfluencer;
import mythruna.world.cave.WallInfluencer;
import mythruna.world.tile.FeatureId;
import mythruna.world.tile.Sedectile;
import mythruna.world.tile.Workspace;
import mythruna.world.tile.WorkspaceFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaveNetworkGenerator
implements WorkspaceFunction {
    static Logger log = LoggerFactory.getLogger(CaveNetworkGenerator.class);
    private static final PointInfluencer NULL_POINT = new PointInfluencer(null, 0, 0);
    public static boolean newStyle = true;
    public static boolean reflectSurface = true;
    public static double surfaceChance = 0.1;
    private WorldFractal worldFractal;
    private EntityData ed;
    private EntityId worldEntity;
    private long seed;
    private int maxCaveBranchDepth = 9;
    private int maxGorgeBranchDepth = 9;
    private double minCaveRadius = 2.0;
    private double maxCaveRadius = 14.0;
    private double caveRadiusRange;
    private double minCaveElevation = this.caveRadiusRange = this.maxCaveRadius - this.minCaveRadius;
    private double splitRadius = this.caveRadiusRange * 0.5;
    private double maxCaveLength = 40.0;
    private int minNodeElevation = 5;
    private double nodeRoughness = 4.0;
    private double edgeRoughness = 2.0;
    private double edgeSplit = 5.0;
    private double minSplitOffset = -5.0;
    private double maxSplitOffset = -5.0;
    private double splitRange = this.maxSplitOffset - this.minSplitOffset;
    private double minGorgeHeight = 16.0;
    private double maxGorgeHeight = 40.0;
    private double gorgeHeightRange = this.maxGorgeHeight - this.minGorgeHeight;
    private double minGorgeRadius = 2.0;
    private double maxGorgeRadius = 14.0;
    private double gorgeRadiusRange = this.maxGorgeRadius - this.minGorgeRadius;
    private double gorgeRoughness = 2.0;
    private double maxGorgeExtend = 40.0;

    public CaveNetworkGenerator(WorldFractal worldFractal, EntityId worldEntity, long seed, EntityData ed) {
        this.worldFractal = worldFractal;
        this.worldEntity = worldEntity;
        this.ed = ed;
        this.seed = seed;
    }

    private double nextDelta(Random rand, double minDistance, double maxDistance) {
        double factor = maxDistance - minDistance;
        double x = rand.nextDouble() * factor * 2.0 - factor;
        x = x < 0.0 ? (x -= minDistance) : (x += minDistance);
        return x;
    }

    private Vec3d randomPosition(Random rand, Vec3i start, double minDistance, double maxDistance) {
        double x = (double)start.x + this.nextDelta(rand, minDistance, maxDistance);
        double y = (double)start.y + this.nextDelta(rand, minDistance, maxDistance);
        double z = (double)start.z + this.nextDelta(rand, minDistance, maxDistance);
        return new Vec3d(x, y, z);
    }

    private Vec3d randomPosition(Random rand, Vec3i start, double minDistance, double maxDistance, double yMinDistance, double yMaxDistance) {
        double x = (double)start.x + this.nextDelta(rand, minDistance, maxDistance);
        double y = (double)start.y + this.nextDelta(rand, yMinDistance, yMaxDistance);
        double z = (double)start.z + this.nextDelta(rand, minDistance, maxDistance);
        return new Vec3d(x, y, z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Workspace workspace) {
        Vec3i workspaceOrigin = workspace.getOrigin(null);
        log.info("Adding cave networks to workspace:" + workspace + "workspaceOrigin:" + workspaceOrigin);
        String name = String.format("Cave generation: %d, %d", workspaceOrigin.x, workspaceOrigin.z);
        ProgressTracker progress = ProgressTrackers.openTracker((String)name);
        try {
            int progressMax = 256;
            progress.setMax((double)progressMax);
            for (int xs = -1; xs <= 1; ++xs) {
                for (int zs = -1; zs <= 1; ++zs) {
                    Sedectile sedectile = workspace.getSedectile(xs, zs);
                    SedectileId id = sedectile.getSedectileId();
                    if (sedectile.isComplete()) {
                        log.info("CaveTileFunction Skipping already generated sedectile:" + id);
                        continue;
                    }
                    long start = System.nanoTime();
                    Vec3i sedectileOrigin = id.getWorld(null);
                    BitSet tileBits = sedectile.getGenerationState(CaveNetwork.class, new BitSet(256));
                    sedectile.setGenerationState(CaveNetwork.class, tileBits);
                    int txStart = 0;
                    int txEnd = 16;
                    if (xs < 0) {
                        txStart = 15;
                    } else if (xs > 0) {
                        txEnd = 1;
                    }
                    int tzStart = 0;
                    int tzEnd = 16;
                    if (zs < 0) {
                        tzStart = 15;
                    } else if (zs > 0) {
                        tzEnd = 1;
                    }
                    for (int tx = txStart; tx < txEnd; ++tx) {
                        for (int tz = tzStart; tz < tzEnd; ++tz) {
                            int x = tx * 1024;
                            int z = tz * 1024;
                            TileId tileId = TileId.fromWorld((int)(sedectileOrigin.x + x), (int)(sedectileOrigin.y + 0), (int)(sedectileOrigin.z + z));
                            int bitIndex = tz * 16 + tx;
                            if (tileBits.get(bitIndex)) {
                                if (log.isTraceEnabled()) {
                                    log.trace("Skipping cave generation for:" + tileId.getWorld(null));
                                }
                                if (xs != 0 || zs != 0) continue;
                                progress.increment();
                                continue;
                            }
                            tileBits.set(bitIndex);
                            if (log.isTraceEnabled()) {
                                log.trace("Generating caves for:" + tileId.getWorld(null));
                            }
                            this.generateCaves(workspace, tileId);
                            if (xs != 0 || zs != 0) continue;
                            progress.increment();
                        }
                    }
                    long end = System.nanoTime();
                    log.info(String.format("Generated caves for %s in %.03f ms", id.getWorld(null).toString(), (double)(end - start) / 1000000.0));
                }
            }
        }
        finally {
            progress.close(true);
        }
    }

    protected void buildLinePath(Random rand, CaveEdge edge) {
        Vec3d start = edge.getEnd1().getPoint().toVec3d();
        Vec3i end = edge.getEnd2().getPoint();
        Vec3d dir = end.toVec3d().subtractLocal(start);
        double length = dir.length();
        int count = length <= this.edgeSplit ? 1 : 1 + rand.nextInt((int)(length / this.edgeSplit));
        double inner = edge.getRadius();
        double outer = inner + rand.nextDouble() * this.edgeRoughness;
        if (count == 1) {
            edge.setInfluencers(new LineInfluencer(edge.getEnd1().getPoint(), end, (int)inner, (int)outer, 0, 128, 1));
            return;
        }
        if (length / (double)count < 2.0) {
            log.warn("Going to end up making null lines.");
        }
        dir.multLocal(1.0 / (double)count);
        Influencer[] influencers = new Influencer[count];
        Vec3d last = start;
        for (int i = 1; i <= count; ++i) {
            Vec3i vi2;
            Vec3i vi1;
            Vec3d v1 = last;
            Vec3d v2 = start.add(dir.x * (double)i, dir.y * (double)i, dir.z * (double)i);
            if (i < count) {
                double dx = this.minSplitOffset + rand.nextDouble() * this.splitRange;
                double dy = this.minSplitOffset + rand.nextDouble() * this.splitRange;
                double dz = this.minSplitOffset + rand.nextDouble() * this.splitRange;
                v2.x += dx;
                v2.y += dy;
                v2.z += dz;
            }
            if ((vi1 = v1.floor()).equals((Object)(vi2 = v2.floor()))) continue;
            influencers[i - 1] = new LineInfluencer(vi1, vi2, (int)inner, (int)outer, 0, 128, 1);
            last = v2;
        }
        edge.setInfluencers(influencers);
    }

    protected Set<Entity> findCaveSystemEntities(TileId tileId) {
        ComponentFilter tileFilter = Filters.fieldEquals(MapMarker.class, (String)"tileId", (Object)tileId.getId());
        int typeId = this.ed.getStrings().getStringId("cave-system", true);
        ComponentFilter typeFilter = Filters.fieldEquals(MapMarker.class, (String)"typeId", (Object)typeId);
        ComponentFilter filter = Filters.and(MapMarker.class, (ComponentFilter[])new ComponentFilter[]{tileFilter, typeFilter});
        EntitySet entities = this.ed.getEntities(filter, new Class[]{MapMarker.class, SpawnPosition.class, Name.class});
        entities.applyChanges();
        HashSet<Entity> results = new HashSet<Entity>((Collection<Entity>)entities);
        entities.release();
        return results;
    }

    protected EntityId getCaveSystemEntity(Set<Entity> entities, Vec3i pos) {
        Iterator<Entity> it = entities.iterator();
        while (it.hasNext()) {
            Entity e = it.next();
            SpawnPosition spawn = (SpawnPosition)e.get(SpawnPosition.class);
            if (!spawn.getLocation().floor().equals((Object)pos)) continue;
            it.remove();
            return e.getId();
        }
        EntityId result = this.ed.createEntity();
        this.ed.setComponents(result, new EntityComponent[]{new SpawnPosition(GameConstants.PHYSICS_GRID, pos.toVec3d()), new Name("Caves:" + result.getId()), MapMarker.create(this.worldEntity, "cave-system", 10, pos.toVec3d(), this.ed)});
        return result;
    }

    protected boolean isAboveSurface(PointInfluencer point) {
        Vec3i center = point.getPoint();
        double elevation = this.worldFractal.getElevation(center.x, center.z);
        return (double)(center.y + point.getOuterRadius()) > elevation;
    }

    protected void generateCaves(Workspace workspace, TileId tileId) {
        Vec3i origin = tileId.getWorld(null);
        Set<Entity> entities = this.findCaveSystemEntities(tileId);
        ListMultimap surfaceMap = MultimapBuilder.hashKeys().arrayListValues().build();
        CaveGraph graph = new CaveGraph();
        Random rand = new Random(this.seed + tileId.getId());
        ArrayList<CaveNode> seeds = new ArrayList<CaveNode>();
        int aboveGround = 1 + rand.nextInt(4);
        int seedCount = aboveGround + rand.nextInt(4);
        double cavernous = rand.nextDouble() + 2.0;
        for (int i = 0; i < seedCount; ++i) {
            double vy;
            double vx = (double)origin.x + rand.nextDouble() * 1024.0;
            double vz = (double)origin.z + rand.nextDouble() * 1024.0;
            double radius = this.minCaveRadius + rand.nextDouble() * this.caveRadiusRange;
            int elev = (int)this.worldFractal.getElevation(vx, vz);
            if (aboveGround > 0) {
                vy = (double)elev + rand.nextDouble() * radius - radius * 0.5;
                --aboveGround;
            } else {
                vy = rand.nextDouble() * (double)elev + this.minCaveElevation;
            }
            Vec3i v = new Vec3i((int)vx, (int)vy, (int)vz);
            EntityId systemId = this.getCaveSystemEntity(entities, v);
            CaveNode node = new CaveNode(systemId.getId(), v, radius, 0);
            if (node.getPoint().y < this.minNodeElevation) {
                node.getPoint().y = this.minNodeElevation;
            }
            graph.addNode(node);
            seeds.add(node);
        }
        if (!entities.isEmpty()) {
            for (Entity e : entities) {
                log.info("Removing state cave system entity:" + e);
                this.ed.removeEntity(e.getId());
            }
        }
        while (!seeds.isEmpty()) {
            CaveNode seed = (CaveNode)seeds.remove(0);
            if (seed.getDepth() > this.maxCaveBranchDepth) {
                seed.setInfluencer(NULL_POINT);
                continue;
            }
            double maxRadius = seed.getRadius();
            int count = 0;
            if (maxRadius < 4.0) {
                double chance = rand.nextDouble();
                count = chance < 0.5 ? 0 : (chance < 0.75 ? 1 : 2);
            } else if (maxRadius < 10.0) {
                count = rand.nextInt(4);
            } else {
                count = rand.nextInt(8);
                maxRadius = this.splitRadius;
            }
            if (seed.getDepth() < 2 && count == 0) {
                count = 4;
            }
            for (int i = 0; i < count; ++i) {
                Vec3i end;
                double chance;
                double tunnelRadius = this.minCaveRadius + rand.nextDouble() * (maxRadius - this.minCaveRadius);
                double length = rand.nextDouble() * this.maxCaveLength;
                double newRadius = seed.getRadius();
                if (newRadius < 5.0 && (chance = rand.nextDouble()) < 0.5) {
                    newRadius *= cavernous;
                }
                double nodeRadius = this.minCaveRadius + rand.nextDouble() * (newRadius - this.minCaveRadius);
                if (newStyle) {
                    double roll;
                    double elevation;
                    double x = rand.nextGaussian();
                    double y = rand.nextGaussian();
                    double z = rand.nextGaussian();
                    if ((length = Math.max(length, seed.getRadius() + tunnelRadius)) < 2.0) {
                        length = 2.0;
                    }
                    Vec3d dir = new Vec3d(x, y, z).normalizeLocal();
                    dir.multLocal(length);
                    end = seed.getPoint().toVec3d().add(dir).floor();
                    if (end.y < this.minNodeElevation) {
                        dir.y *= -1.0;
                        end = seed.getPoint().toVec3d().addLocal(dir).floor();
                    } else if (reflectSurface && (double)end.y + nodeRadius >= (elevation = this.worldFractal.getElevation(end.x, end.z)) && (double)end.y - dir.y > (double)this.minNodeElevation && (roll = rand.nextDouble()) > surfaceChance) {
                        dir.y *= -1.0;
                        end = seed.getPoint().toVec3d().addLocal(dir).floor();
                    }
                    if (end.y < this.minNodeElevation) {
                        end.y = this.minNodeElevation;
                    }
                } else {
                    end = this.randomPosition(rand, seed.getPoint(), seed.getRadius() + tunnelRadius, length, 0.0, 20.0).floor();
                    if (end.y < this.minNodeElevation) {
                        end.y = this.minNodeElevation;
                    }
                }
                CaveEdge edge = seed.extend(end, tunnelRadius);
                if (edge.getEnd1().getPoint().equals((Object)edge.getEnd2().getPoint())) {
                    throw new IllegalArgumentException("Endpoints are invalid:" + edge);
                }
                graph.addEdge(edge);
                CaveNode node = edge.adjacent(seed);
                node.setRadius(nodeRadius);
                seeds.add(node);
            }
        }
        for (CaveNode node : graph.getNodes()) {
            if (node.getInfluencer() == NULL_POINT) {
                node.setInfluencer(null);
                continue;
            }
            double inner = node.getRadius();
            double outer = inner + rand.nextDouble() * this.nodeRoughness;
            node.setInfluencer(new PointInfluencer(node.getPoint(), (int)inner, (int)outer, 0, 128, 1));
        }
        for (CaveEdge edge : graph.getEdges()) {
            if (edge.getInfluencers() != null) continue;
            this.buildLinePath(rand, edge);
        }
        int gorgeCount = 2 + rand.nextInt(5);
        ArrayList<CaveNode> nodes = new ArrayList<CaveNode>(graph.getNodes());
        for (int i = 0; i < gorgeCount && !nodes.isEmpty(); ++i) {
            int index = rand.nextInt(nodes.size());
            CaveNode start = (CaveNode)nodes.remove(index);
            Vec3i point = start.getPoint().clone();
            point.z += (int)(this.minCaveRadius + rand.nextDouble() * this.caveRadiusRange);
            CaveNode caveNode = new CaveNode(start.getCaveSystemId(), point, this.maxGorgeExtend, 0);
            seeds.add(caveNode);
            graph.addEdge(new CaveEdge(start, caveNode, 0.0));
        }
        while (!seeds.isEmpty()) {
            CaveNode seed = (CaveNode)seeds.remove(0);
            if (seed.getDepth() > this.maxGorgeBranchDepth) continue;
            int split = 1;
            if (seed.getDepth() == 0) {
                split = 2;
            }
            Vec3i base = seed.getPoint();
            double height = this.minGorgeHeight + rand.nextDouble() * this.gorgeHeightRange;
            for (int i = 0; i < split; ++i) {
                double chance;
                Vec3d dir = this.randomPosition(rand, new Vec3i(), -1.0, 1.0);
                dir.normalizeLocal();
                double max = seed.getRadius();
                if (max < 4.0 && (chance = rand.nextDouble()) < 0.5) {
                    max *= cavernous;
                }
                double inner = this.minGorgeRadius + rand.nextDouble() * this.gorgeRadiusRange;
                double outer = inner + rand.nextDouble() * this.gorgeRoughness;
                double lengthMin = Math.max(5.0, max * 0.3);
                double lengthRange = Math.max(1.0, max - lengthMin);
                double length = lengthMin + rand.nextDouble() * lengthRange;
                Vec3i loc = base.toVec3d().addLocal(dir.mult(length)).floor();
                loc.y = Math.max((int)this.minGorgeRadius, loc.y);
                double nextMax = rand.nextDouble() * length;
                CaveNode end = new CaveNode(seed.getCaveSystemId(), loc, nextMax, seed.getDepth() + 1);
                CaveEdge edge = new CaveEdge(seed, end, (int)inner);
                graph.addEdge(edge);
                if (!base.equals((Object)loc)) {
                    WallInfluencer wall = new WallInfluencer(base, loc, (int)height, (int)inner, (int)outer, 0, 128, 1);
                    edge.setInfluencers(wall);
                } else {
                    log.warn("Skipping wall influencer with same start and end:" + loc);
                }
                if (!(nextMax > 2.0)) continue;
                seeds.add(end);
            }
        }
        CaveNetwork caves = new CaveNetwork(FeatureId.create(CaveNetwork.class, tileId.getId()));
        for (CaveNode node : graph.getNodes()) {
            PointInfluencer influencer = node.getInfluencer();
            if (influencer == null) continue;
            caves.addInfluencer(influencer);
            if (!this.isAboveSurface(influencer)) continue;
            surfaceMap.put((Object)node.getCaveSystemId(), (Object)node);
        }
        for (CaveEdge edge : graph.getEdges()) {
            Influencer[] influencers = edge.getInfluencers();
            if (influencers == null) continue;
            for (Influencer i : influencers) {
                if (i == null) continue;
                caves.addInfluencer(i);
            }
        }
        for (Long id : surfaceMap.keySet()) {
            int count = surfaceMap.get((Object)id).size();
            EntityId entityId = new EntityId(id.longValue());
            MapMarker marker = (MapMarker)this.ed.getComponent(entityId, MapMarker.class);
            if (marker == null) {
                log.error("No marker for known cave entity:" + entityId);
                continue;
            }
            count /= 10;
            if ((count += 10) > 40) {
                count = 40;
            }
            marker = marker.changeSize(count);
            if (log.isTraceEnabled()) {
                log.trace("marker for:" + entityId + "  size:" + marker.getSize());
            }
            this.ed.setComponent(entityId, (EntityComponent)marker);
        }
        workspace.addFeature(caves);
    }
}

