/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.river;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.morph.Morphology;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import mythruna.world.TerrainTypes;
import mythruna.world.river.RiverSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiverTileFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(RiverTileFunction.class);
    private int seaLevel = 128;

    public void accept(Tile tile) {
        this.accept4(tile);
    }

    public void accept4(Tile tile) {
        MorphologyLayer morph = (MorphologyLayer)tile.get(MorphologyLayer.class);
        if (morph == null) {
            morph = new MorphologyLayer(tile.getTileId(), new DataVersion(0L, -1L));
            tile.put(MorphologyLayer.class, (Object)morph);
        } else if (morph.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        int riverDepth = 5;
        int riverRadius = 5;
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        Vec3i origin = tile.getTileId().getWorld(null);
        Vec3i highest = null;
        short maxElevation = 0;
        for (int x = 16; x < 1008; ++x) {
            for (int z = 16; z < 1008; ++z) {
                short y = terrain.getElevation(x, z);
                if (y <= maxElevation) continue;
                highest = new Vec3i(x, (int)y, z);
                maxElevation = y;
            }
        }
        LinkedList<Vec3i> pending = new LinkedList<Vec3i>();
        ArrayList<Vec3i> path = new ArrayList<Vec3i>();
        pending.add(highest);
        boolean[][] visited = new boolean[1024][1024];
        for (int x = 0; x < 1024; ++x) {
            for (int z = 0; z < 1024; ++z) {
                if (x < 8 || z < 8) {
                    visited[x][z] = true;
                } else if (x >= 1016 || x >= 1026) {
                    visited[x][z] = true;
                }
                if (x != 0 && z != 0) continue;
                terrain.setType(x, z, (byte)4);
            }
        }
        int visitRadius = 12;
        block4: while (!pending.isEmpty()) {
            Vec3i v = (Vec3i)pending.removeFirst();
            path.add(v);
            if (v.y < this.seaLevel - riverDepth) break;
            for (int i = -visitRadius; i <= visitRadius; ++i) {
                for (int k = -visitRadius; k <= visitRadius; ++k) {
                    int x = v.x + i;
                    int z = v.z + k;
                    if (x < 0 || z < 0 || x >= 1024 || z >= 1024) continue;
                    visited[x][z] = true;
                }
            }
            Vec3i min = null;
            for (double searchRadius = 16.0; searchRadius < 64.0; searchRadius += 16.0) {
                short y;
                int z;
                int x;
                double zd;
                double xd;
                double rads;
                int i;
                int radials = 360;
                double deltaRads = Math.PI * 2 / (double)radials;
                int minElevation = v.y;
                min = null;
                for (i = 0; i < radials; ++i) {
                    rads = deltaRads * (double)i;
                    xd = Math.cos(rads) * searchRadius;
                    zd = Math.sin(rads) * searchRadius;
                    x = (int)((double)v.x + xd);
                    z = (int)((double)v.z + zd);
                    if (x < 0 || z < 0 || x >= 1024 || z >= 1024 || visited[x][z] || (y = terrain.getElevation(x, z)) >= minElevation) continue;
                    min = new Vec3i(x, (int)y, z);
                    minElevation = y;
                }
                if (min != null) {
                    pending.add(min);
                    continue block4;
                }
                minElevation = v.y;
                min = null;
                for (i = 0; i < radials; ++i) {
                    rads = deltaRads * (double)i;
                    xd = Math.cos(rads) * searchRadius;
                    zd = Math.sin(rads) * searchRadius;
                    x = (int)((double)v.x + xd);
                    z = (int)((double)v.z + zd);
                    if (x < 0 || z < 0 || x >= 1024 || z >= 1024 || visited[x][z] || (y = terrain.getElevation(x, z)) > minElevation) continue;
                    min = new Vec3i(x, (int)y, z);
                    minElevation = y;
                }
                if (min == null) continue;
                pending.add(min);
                continue block4;
            }
        }
        Collections.reverse(path);
        Vec3i last = null;
        for (Vec3i v : path) {
            v = origin.add(v);
            if (v.y < this.seaLevel) {
                v.y = this.seaLevel;
            }
            if (last != null) {
                morph.addMorphology((Morphology)new RiverSection(last, v, riverDepth, 15, riverRadius));
            }
            last = v;
        }
    }

    public void accept3(Tile tile) {
        MorphologyLayer morph = (MorphologyLayer)tile.get(MorphologyLayer.class);
        if (morph == null) {
            morph = new MorphologyLayer(tile.getTileId(), new DataVersion(0L, -1L));
            tile.put(MorphologyLayer.class, (Object)morph);
        }
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        Vec3i origin = tile.getTileId().getWorld(null);
        Vec3i last = null;
        for (int z = 128; z < 1024; z += 256) {
            last = null;
            for (int x = 0; x < 1024; x += 16) {
                short y = terrain.getElevation(x, z);
                Vec3i v = origin.add(x, (int)y, z);
                if (last != null) {
                    morph.addMorphology((Morphology)new RiverSection(last, v, 5, 15, 5));
                }
                last = v;
            }
        }
    }

    private int mix(int v1, int v2, double mix) {
        double d = (double)v1 * (1.0 - mix) + (double)v2 * mix;
        return (int)Math.round(d);
    }

    private double clamp(double v, double min, double max) {
        v = Math.max(v, min);
        return Math.min(v, max);
    }

    private double smoothStep(double edge0, double edge1, double x) {
        double t = this.clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    public void accept2(Tile tile) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = terrain.getSize();
        int skip = 1024 / size;
        int influence = 15;
        int riverRadius = 5;
        int riverDepth = 5;
        int[] rivers = new int[32];
        Arrays.fill(rivers, -1);
        for (int z = 128; z < size; z += 256) {
            int min = (z - influence) / 32;
            int max = (z + influence) / 32;
            for (int i = min; i <= max; ++i) {
                rivers[i] = z;
            }
        }
        int[][] riverHeights = new int[rivers.length][size];
        for (int i = 0; i < 32; ++i) {
            if (rivers[i] == -1) continue;
            int[] heights = riverHeights[i];
            for (int x = 0; x < size; ++x) {
                heights[x] = terrain.getElevation(x, rivers[i]);
            }
        }
        int[] diagonal = new int[size];
        for (int i = 0; i < size; ++i) {
            diagonal[i] = terrain.getElevation(i, i);
        }
        for (int x = 0; x < size; x += skip) {
            for (int z = 0; z < size; z += skip) {
                for (int i = 0; i < 2; ++i) {
                    double d;
                    int riverLevel;
                    if (i == 0) {
                        int col = z / 32;
                        int zRiver = rivers[col];
                        if (zRiver == -1) continue;
                        riverLevel = riverHeights[col][x];
                        d = Math.abs(z - zRiver);
                    } else {
                        double dx = (double)(z - x) * 0.5;
                        d = Math.abs(dx);
                        d = Math.sqrt(d * d + d * d);
                        riverLevel = diagonal[x + (int)dx];
                    }
                    if (d > (double)influence) continue;
                    int y = terrain.getElevation(x, z);
                    if (d <= (double)riverRadius) {
                        int yRiver = Math.max(riverLevel, fluid.getElevation(x, z));
                        y = Math.min(y, yRiver - riverDepth);
                        terrain.setElevation(x, z, (short)y);
                        byte type = terrain.getType(x, z);
                        terrain.setType(x, z, TerrainTypes.setFoliageLevel(type, 0));
                        if (fluid.getElevation(x, z) >= yRiver) continue;
                        fluid.setElevation(x, z, (short)yRiver);
                        fluid.setType(x, z, (byte)1);
                        continue;
                    }
                    if (y >= riverLevel || fluid.getType(x, z) > 0) continue;
                    double mix = 1.0 - (d - (double)riverRadius) / (double)(influence - riverRadius - 1);
                    mix = this.smoothStep(0.0, 1.0, mix);
                    y = this.mix(y, riverLevel, mix);
                    terrain.setElevation(x, z, (short)y);
                }
            }
        }
    }

    public void accept1(Tile tile) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = terrain.getSize();
        int radius = 5;
        int riverDepth = 5;
        int raiseRadius = 15;
        int border = raiseRadius - radius;
        for (int i = 0; i < size; ++i) {
            for (int k = 128; k < size; k += 256) {
                int foliage;
                int y;
                int r;
                int b;
                int riverLevel = Math.max(terrain.getElevation(i, k), fluid.getElevation(i, k));
                for (b = 0; b < border; ++b) {
                    r = -(radius + b + 1);
                    y = terrain.getElevation(i, k + r);
                    if (y < riverLevel) {
                        double mix = 1.0 - (double)b / (double)border;
                        mix = this.smoothStep(0.0, 1.0, mix);
                        y = this.mix(y, riverLevel, mix);
                        terrain.setElevation(i, k + r, (short)y);
                    }
                    if (b != 0) continue;
                    byte type = terrain.getType(i, k + r);
                    foliage = TerrainTypes.getFoliageLevel(type);
                    if (y - riverLevel >= 2) {
                        foliage = 0;
                    }
                    type = TerrainTypes.setFoliageLevel(type, Math.min(1, foliage));
                    terrain.setType(i, k + r, type);
                }
                for (b = 0; b < border; ++b) {
                    r = radius + b + 1;
                    y = terrain.getElevation(i, k + r);
                    if (y < riverLevel) {
                        double mix = 1.0 - (double)b / (double)border;
                        mix = this.smoothStep(0.0, 1.0, mix);
                        y = this.mix(y, riverLevel, mix);
                        terrain.setElevation(i, k + r, (short)y);
                    }
                    if (b != 0) continue;
                    byte type = terrain.getType(i, k + r);
                    foliage = TerrainTypes.getFoliageLevel(type);
                    if (y - riverLevel >= 2) {
                        foliage = 0;
                    }
                    type = TerrainTypes.setFoliageLevel(type, Math.min(1, foliage));
                    terrain.setType(i, k + r, type);
                }
                for (int r2 = -radius; r2 <= radius; ++r2) {
                    int depth;
                    short y2 = terrain.getElevation(i, k + r2);
                    double df = (double)Math.abs(r2) / (double)(radius + 1);
                    if (y2 > riverLevel - (depth = riverDepth - (int)((df *= df) * (double)riverDepth))) {
                        terrain.setElevation(i, k + r2, (short)(riverLevel - depth));
                    }
                    if (fluid.getElevation(i, k + r2) >= riverLevel) continue;
                    fluid.setElevation(i, k + r2, (short)riverLevel);
                    fluid.setType(i, k + r2, (byte)1);
                }
            }
        }
    }
}

