/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.account.base;

import com.simsilica.account.Account;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccount
implements Account {
    static Logger log = LoggerFactory.getLogger(DefaultAccount.class);
    public static final String PROP_NAME = "name";
    private String globalUserId;
    private String userId;
    private Map<String, Object> properties;

    public DefaultAccount(String globalUserId, String userId, Map<String, Object> properties) {
        this.globalUserId = globalUserId;
        this.userId = userId;
        this.properties = properties;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getGlobalUserId() {
        return this.globalUserId;
    }

    @Override
    public String getName() {
        Object name = this.properties.get(PROP_NAME);
        if (name == null) {
            return this.userId;
        }
        return String.valueOf(name);
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Object result = this.properties.get(name);
        if (result == null) {
            return null;
        }
        return type.cast(result);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[userId:" + this.userId + ", globalUserId:" + this.globalUserId + "]";
    }
}

