/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.font.BitmapFont;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.TextComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;

public class Label
extends Panel {
    public static final String ELEMENT_ID = "label";
    public static final String LAYER_ICON = "icon";
    public static final String LAYER_TEXT = "text";
    public static final String LAYER_SHADOW_TEXT = "shadowText";
    private TextComponent text;
    private TextComponent shadow;
    private Vector3f shadowOffset = new Vector3f(1.0f, -1.0f, -1.0f);

    public Label(String s) {
        this(s, true, new ElementId(ELEMENT_ID), null);
    }

    public Label(String s, String style) {
        this(s, true, new ElementId(ELEMENT_ID), style);
    }

    public Label(String s, ElementId elementId) {
        this(s, true, elementId, null);
    }

    public Label(String s, ElementId elementId, String style) {
        this(s, true, elementId, style);
    }

    protected Label(String s, boolean applyStyles, ElementId elementId, String style) {
        super(false, elementId, style);
        ((GuiControl)this.getControl(GuiControl.class)).setLayerOrder("insets", "border", "background", LAYER_ICON, LAYER_SHADOW_TEXT, LAYER_TEXT);
        Styles styles = GuiGlobals.getInstance().getStyles();
        BitmapFont font = styles.getAttributes(elementId.getId(), style).get("font", BitmapFont.class);
        this.text = new TextComponent(s, font);
        this.text.setLayer(3);
        ((GuiControl)this.getControl(GuiControl.class)).setComponent(LAYER_TEXT, this.text);
        if (applyStyles) {
            styles.applyStyles((Object)this, elementId, style);
        }
    }

    @StyleDefaults(value="label")
    public static void initializeDefaultStyles(Attributes attrs) {
    }

    @StyleAttribute(value="text", lookupDefault=false)
    public void setText(String s) {
        this.text.setText(s);
        if (this.shadow != null) {
            this.shadow.setText(s);
        }
    }

    public String getText() {
        return this.text == null ? null : this.text.getText();
    }

    @StyleAttribute(value="textVAlignment", lookupDefault=false)
    public void setTextVAlignment(VAlignment a) {
        this.text.setVAlignment(a);
        if (this.shadow != null) {
            this.shadow.setVAlignment(a);
        }
    }

    public VAlignment getTextVAlignment() {
        return this.text.getVAlignment();
    }

    @StyleAttribute(value="textHAlignment", lookupDefault=false)
    public void setTextHAlignment(HAlignment a) {
        this.text.setHAlignment(a);
        if (this.shadow != null) {
            this.shadow.setHAlignment(a);
        }
    }

    public HAlignment getTextHAlignment() {
        return this.text.getHAlignment();
    }

    @StyleAttribute(value="maxWidth", lookupDefault=false)
    public void setMaxWidth(float f) {
        this.text.setMaxWidth(f);
        if (this.shadow != null) {
            this.shadow.setMaxWidth(f);
        }
    }

    public float getMaxWidth() {
        return this.text.getMaxWidth();
    }

    public void setFont(BitmapFont font) {
        this.text.setFont(font);
        if (this.shadow != null) {
            this.shadow.setFont(font);
        }
    }

    public BitmapFont getFont() {
        return this.text.getFont();
    }

    @StyleAttribute(value="color")
    public void setColor(ColorRGBA color) {
        this.text.setColor(color);
    }

    public ColorRGBA getColor() {
        return this.text == null ? null : this.text.getColor();
    }

    @StyleAttribute(value="fontSize")
    public void setFontSize(float f) {
        this.text.setFontSize(f);
        if (this.shadow != null) {
            this.shadow.setFontSize(f);
        }
    }

    public float getFontSize() {
        return this.text == null ? 0.0f : this.text.getFontSize();
    }

    @StyleAttribute(value="shadowOffset")
    public void setShadowOffset(Vector3f offset) {
        this.shadowOffset.set(offset);
        if (this.shadow != null) {
            this.shadow.setOffset(offset.x, offset.y, offset.z);
        }
    }

    public Vector3f getShadowOffset() {
        return this.shadowOffset;
    }

    @StyleAttribute(value="shadowColor", lookupDefault=false)
    public void setShadowColor(ColorRGBA color) {
        if (this.shadow == null) {
            if (color == null) {
                return;
            }
            this.shadow = new TextComponent(this.getText(), this.getFont());
            this.shadow.setLayer(2);
            this.shadow.setOffset(this.shadowOffset.x, this.shadowOffset.y, this.shadowOffset.z);
            this.shadow.setFontSize(this.getFontSize());
            this.shadow.setHAlignment(this.text.getHAlignment());
            this.shadow.setVAlignment(this.text.getVAlignment());
            this.shadow.setMaxWidth(this.text.getMaxWidth());
            ((GuiControl)this.getControl(GuiControl.class)).setComponent(LAYER_SHADOW_TEXT, this.shadow);
        } else if (color == null) {
            ((GuiControl)this.getControl(GuiControl.class)).removeComponent(this.shadow);
            this.shadow = null;
            return;
        }
        this.shadow.setColor(color);
    }

    public ColorRGBA getShadowColor() {
        if (this.shadow == null) {
            return null;
        }
        return this.shadow.getColor();
    }

    @StyleAttribute(value="icon", lookupDefault=false)
    public void setIcon(GuiComponent icon) {
        ((GuiControl)this.getControl(GuiControl.class)).setComponent(LAYER_ICON, icon);
    }

    public GuiComponent getIcon() {
        return ((GuiControl)this.getControl(GuiControl.class)).getComponent(LAYER_ICON);
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[text=" + this.getText() + ", color=" + this.getColor() + ", elementId=" + this.getElementId() + "]";
    }
}

