/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.PersistentComponent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Morph
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(Morph.class);
    private EntityId target;
    private int verbId;
    private double mix;

    protected Morph() {
    }

    public Morph(EntityId target, int verbId, double mix) {
        this.target = target;
        this.verbId = verbId;
        this.mix = mix;
    }

    public static Morph create(EntityId target, String verb, double mix, EntityData ed) {
        int id = ed.getStrings().getStringId(verb, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(verb, true);
        }
        Morph result = new Morph(target, id, mix);
        return result;
    }

    public Morph changeMix(double mix) {
        return new Morph(this.target, this.verbId, mix);
    }

    public static ComponentFilter<Morph> filter(EntityId target) {
        return Filters.fieldEquals(Morph.class, (String)"target", (Object)target);
    }

    public static ComponentFilter<Morph> filter(EntityId target, String verb, EntityData ed) {
        int id = ed.getStrings().getStringId(verb, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(verb, true);
        }
        ComponentFilter targetFilter = Filters.fieldEquals(Morph.class, (String)"target", (Object)target);
        ComponentFilter verbFilter = Filters.fieldEquals(Morph.class, (String)"verbId", (Object)id);
        return Filters.and(Morph.class, (ComponentFilter[])new ComponentFilter[]{targetFilter, verbFilter});
    }

    public EntityId getTarget() {
        return this.target;
    }

    public int getVerbId() {
        return this.verbId;
    }

    public String getVerbString(EntityData ed) {
        if (this.verbId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.verbId);
    }

    public double getMix() {
        return this.mix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Morph other = (Morph)o;
        if (!Objects.equals(this.target, other.target)) {
            return false;
        }
        if (this.verbId != this.verbId) {
            return false;
        }
        return this.mix == this.mix;
    }

    public int hashCode() {
        return Objects.hash(this.target, this.verbId, this.mix);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.verbId) : this.getVerbString(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("target", (Object)this.target).add("verb", (Object)s).add("mix", this.mix).toString();
    }
}

