/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.FluidName;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mworld.CellGenType;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileColumnProcessor;
import com.simsilica.mworld.tile.TileManager;
import mythruna.world.TerrainTypes;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseColumnProcessor
implements TileColumnProcessor {
    static Logger log = LoggerFactory.getLogger(BaseColumnProcessor.class);
    public static final int TERRAIN_BITS = CellGenType.Terrain.apply(0);
    private WorldFractal fractal;
    private TileManager tileManager;
    private int sandType;
    private int dirtType;
    private int dryGrassType;
    private int grassType;
    private int stoneType;
    private int sandstoneType;
    private int darkGraniteType;
    private int obsidianType;
    private int chalkType;
    private int snowType;
    private int iceType;
    private int badType;
    private int testType1;
    private int testType2;
    private int testType3;
    private int testType4;
    private int testType5;
    private int testType6;
    private int waterType;
    private int seaLevel = 128;
    private int treeLine = 618;

    public BaseColumnProcessor(WorldFractal fractal, TileManager tileManager) {
        this.fractal = fractal;
        this.tileManager = tileManager;
        this.badType = BlockTypeIndex.getBadTypeIndex();
        this.sandType = BlockTypeIndex.findType((BlockName)new BlockName("sand", "cube"), (int)1) | TERRAIN_BITS;
        this.dirtType = BlockTypeIndex.findType((BlockName)new BlockName("dirt", "cube"), (int)1) | TERRAIN_BITS;
        this.grassType = BlockTypeIndex.findType((BlockName)new BlockName("grass", "cube"), (int)1) | TERRAIN_BITS;
        this.dryGrassType = BlockTypeIndex.findType((BlockName)new BlockName("dry-grass", "cube"), (int)1) | TERRAIN_BITS;
        this.sandstoneType = BlockTypeIndex.findType((BlockName)new BlockName("sandstone", "cube"), (int)1) | TERRAIN_BITS;
        this.stoneType = BlockTypeIndex.findType((BlockName)new BlockName("stone", "cube"), (int)1) | TERRAIN_BITS;
        this.darkGraniteType = BlockTypeIndex.findType((BlockName)new BlockName("dark-granite", "cube"), (int)1) | TERRAIN_BITS;
        this.obsidianType = BlockTypeIndex.findType((BlockName)new BlockName("bmarble", "cube"), (int)1) | TERRAIN_BITS;
        this.chalkType = BlockTypeIndex.findType((BlockName)new BlockName("wmarble", "cube"), (int)1) | TERRAIN_BITS;
        this.snowType = BlockTypeIndex.findType((BlockName)new BlockName("snow", "cube"), (int)1) | TERRAIN_BITS;
        this.iceType = BlockTypeIndex.findType((BlockName)new BlockName("ice", "cube"), (int)1) | TERRAIN_BITS;
        this.testType1 = BlockTypeIndex.findType((BlockName)new BlockName("bmarble", "cube"), (int)1) | TERRAIN_BITS;
        this.testType2 = BlockTypeIndex.findType((BlockName)new BlockName("wmarble", "cube"), (int)1) | TERRAIN_BITS;
        this.testType3 = BlockTypeIndex.findType((BlockName)new BlockName("leather", "cube"), (int)1) | TERRAIN_BITS;
        this.testType4 = BlockTypeIndex.findType((BlockName)new BlockName("steel", "cube"), (int)1) | TERRAIN_BITS;
        this.testType5 = BlockTypeIndex.findType((BlockName)new BlockName("wood", "cube"), (int)1) | TERRAIN_BITS;
        this.testType6 = BlockTypeIndex.findType((BlockName)new BlockName("shrub", "cube"), (int)1) | TERRAIN_BITS;
        this.waterType = FluidTypeIndex.findType((FluidName)new FluidName("water"), (int)1);
    }

    public boolean apply(ColumnData col, Tile tile) {
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluidLevels = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        ColumnId columnId = col.getColumnId();
        Vec3i local = columnId.getTileLocal(null);
        Vec3i origin = tile.getTileId().getWorld(null);
        int size = 32;
        int leafCount = col.getLeafs().length;
        for (int i = 0; i < size; ++i) {
            block10: for (int k = 0; k < size; ++k) {
                int xp = local.x + i;
                int zp = local.z + k;
                boolean debug = false;
                if (debug) {
                    log.info("Debugging:" + xp + ", " + zp);
                }
                int elevation = terrain.getElevation(xp, zp);
                byte type = terrain.getType(xp, zp);
                int baseType = TerrainTypes.getBaseType(type);
                int foliage = TerrainTypes.getFoliageLevel(type);
                int wet = TerrainTypes.getWetnessLevel(type);
                boolean frozen = TerrainTypes.isFrozen(type);
                short fluidLevel = fluidLevels.getElevation(xp, zp);
                byte fluidType = fluidLevels.getType(xp, zp);
                if (wet == 0) {
                    frozen = false;
                }
                int topElevation = elevation;
                if (frozen && elevation > fluidLevel - 1) {
                    --topElevation;
                }
                if (debug) {
                    log.info("original elevation:" + elevation + "  topElevation:" + topElevation + "  type:" + type);
                }
                int block1 = 0;
                int depth1 = 0;
                int block2 = 0;
                int depth2 = 0;
                int block3 = 0;
                switch (baseType) {
                    case 0: {
                        block1 = this.sandType;
                        depth1 = topElevation - 2;
                        block2 = this.dirtType;
                        depth2 = topElevation - 4;
                        block3 = this.stoneType;
                        break;
                    }
                    case 1: {
                        block1 = foliage == 0 ? this.dirtType : (wet < 1 ? this.dryGrassType : this.grassType);
                        depth1 = topElevation - 1;
                        block2 = this.dirtType;
                        depth2 = topElevation - 4;
                        block3 = this.stoneType;
                        break;
                    }
                    case 7: {
                        block1 = this.iceType;
                        depth1 = topElevation - 2;
                        block2 = this.stoneType;
                        depth2 = 0;
                        break;
                    }
                    case 2: {
                        block1 = this.sandstoneType;
                        depth1 = 0;
                        break;
                    }
                    case 3: {
                        block1 = this.darkGraniteType;
                        depth1 = 0;
                        break;
                    }
                    case 4: {
                        block1 = this.obsidianType;
                        depth1 = 0;
                        break;
                    }
                    case 5: {
                        block1 = this.stoneType;
                        depth1 = 0;
                        break;
                    }
                    default: {
                        block1 = this.chalkType;
                        depth1 = 0;
                    }
                }
                int y = 0;
                for (int layer = 0; layer < leafCount; ++layer) {
                    LeafData leaf = col.getLeafData(y);
                    FluidData fluid = col.getFluidData(y);
                    int j = 0;
                    while (j < 32) {
                        if (debug) {
                            log.info("layer:" + layer + "  y:" + y + "  j:" + j + "  elevation:" + elevation);
                        }
                        if (y == 0) {
                            leaf.setCell(i, j, k, this.dirtType);
                        } else if (y >= elevation) {
                            if (y < fluidLevel - 1) {
                                fluid.setCell(i, j, k, FluidUtils.setLevel((int)this.waterType, (int)8));
                            } else {
                                if (y != fluidLevel - 1) break;
                                fluid.setCell(i, j, k, FluidUtils.setLevel((int)this.waterType, (int)6));
                            }
                        } else if (frozen && y == topElevation) {
                            if (debug) {
                                log.info("Writing snow:" + i + ", " + j + ", " + k);
                            }
                            leaf.setCell(i, j, k, this.snowType);
                        } else if (y < depth2) {
                            leaf.setCell(i, j, k, block3);
                        } else if (y < depth1) {
                            leaf.setCell(i, j, k, block2);
                        } else if (y < elevation) {
                            leaf.setCell(i, j, k, block1);
                        }
                        ++j;
                        ++y;
                    }
                    if (debug) {
                        log.info("y:" + y + "  elevation:" + elevation + "  fluidLevel:" + fluidLevel);
                    }
                    if (y > elevation && y > fluidLevel) continue block10;
                }
            }
        }
        return true;
    }
}

