/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.morph.AbstractMorphology;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import mythruna.world.cave.Influencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineInfluencer
extends AbstractMorphology
implements Influencer,
Serializable {
    static Logger log = LoggerFactory.getLogger(LineInfluencer.class);
    private static final long serialVersionUID = 42L;
    private Vec3i start;
    private Vec3i end;
    private int innerRadius;
    private int outerRadius;
    private byte type;
    private short fluidLevel;
    private byte fluidType;
    public static boolean tileCalcOn = true;
    public static boolean columnCalcOn = true;
    public static boolean oldWay = false;
    public static boolean simplifiedWay = false;
    public static int curveType = 5;
    public static double roughnessThreshold = 0.1;

    public LineInfluencer(Vec3i start, Vec3i end, int innerRadius, int outerRadius) {
        this(start, end, innerRadius, outerRadius, 0, 0, 0);
    }

    public LineInfluencer(Vec3i start, Vec3i end, int innerRadius, int outerRadius, int type, int fluidLevel, int fluidType) {
        if (Objects.equals(start, end)) {
            throw new IllegalArgumentException("Start and end cannot be the same point");
        }
        this.start = start;
        this.end = end;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.type = (byte)type;
        this.fluidLevel = (short)fluidLevel;
        this.fluidType = (byte)fluidType;
    }

    public Vec3i getStart() {
        return this.start;
    }

    public Vec3i getEnd() {
        return this.end;
    }

    public int getInnerRadius() {
        return this.innerRadius;
    }

    public int getOuterRadius() {
        return this.outerRadius;
    }

    @Override
    public Vec3d getCenter() {
        return this.end.toVec3d().subtractLocal(this.start).multLocal(0.5);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public int getFluidLevel() {
        return this.fluidLevel;
    }

    public byte getFluidType() {
        return this.fluidType;
    }

    @Override
    public Vec3i getMin() {
        Vec3i min = this.start.clone().minLocal(this.end);
        return min.subtract(this.outerRadius, 0, this.outerRadius);
    }

    @Override
    public Vec3i getMax() {
        Vec3i max = this.start.clone().maxLocal(this.end);
        return max.add(this.outerRadius, 0, this.outerRadius);
    }

    public Iterable<Short> getAffectedColumns(TileId tileId) {
        ArrayList<Short> results = new ArrayList<Short>();
        Vec3i origin = tileId.getWorld(null);
        int xMin = Math.min(this.start.x, this.end.x) - this.outerRadius - origin.x;
        int zMin = Math.min(this.start.z, this.end.z) - this.outerRadius - origin.z;
        int xMax = Math.max(this.start.x, this.end.x) + this.outerRadius - origin.x;
        int zMax = Math.max(this.start.z, this.end.z) + this.outerRadius - origin.z;
        if (xMax < 0 || zMax < 0) {
            return results;
        }
        if (xMin >= 1024 || zMin >= 1024) {
            return results;
        }
        xMin = Math.max(0, xMin);
        xMax = Math.min(xMax, 1023);
        zMin = Math.max(0, zMin);
        zMax = Math.min(zMax, 1023);
        Vec3i min = ColumnId.GRID.worldToCell((double)xMin, 0.0, (double)zMin);
        Vec3i max = ColumnId.GRID.worldToCell((double)xMax, 0.0, (double)zMax);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                short id = ColumnId.toTileLocalIndexId((int)x, (int)z);
                results.add(id);
            }
        }
        return results;
    }

    private double clamp(double v, double min, double max) {
        if (v <= min) {
            return min;
        }
        if (v >= max) {
            return max;
        }
        return v;
    }

    private int mix(int v1, int v2, double mix) {
        double d = (double)v1 * (1.0 - mix) + (double)v2 * mix;
        return (int)Math.round(d);
    }

    private double smoothStep(double x) {
        double t = this.clamp(x, 0.0, 1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    @Override
    public boolean intersects(TileId tileId) {
        Vec3i tileOrigin = tileId.getWorld(null);
        Vec3i min = this.start.clone().minLocal(this.end);
        Vec3i max = this.start.clone().maxLocal(this.end);
        min.subtractLocal(this.outerRadius, 0, this.outerRadius);
        max.addLocal(this.outerRadius, 0, this.outerRadius);
        if (max.x < tileOrigin.x || max.z < tileOrigin.z) {
            return false;
        }
        return min.x < tileOrigin.x + 1024 && min.z < tileOrigin.z + 1024;
    }

    public boolean morph(Tile tile, Random rand) {
        if (!tileCalcOn) {
            return false;
        }
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = terrain.getSize();
        int spread = 1024 / size;
        TileId tileId = tile.getTileId();
        Vec3i origin = tileId.getWorld(null);
        int xMin = Math.min(this.start.x, this.end.x) - this.outerRadius - origin.x;
        int zMin = Math.min(this.start.z, this.end.z) - this.outerRadius - origin.z;
        int xMax = Math.max(this.start.x, this.end.x) + this.outerRadius - origin.x;
        int zMax = Math.max(this.start.z, this.end.z) + this.outerRadius - origin.z;
        xMin = Math.max(xMin, 0);
        zMin = Math.max(zMin, 0);
        xMax = Math.min(xMax, 1023);
        zMax = Math.min(zMax, 1023);
        xMin /= spread;
        zMin /= spread;
        xMax /= spread;
        zMax /= spread;
        int yMinFull = Math.min(640, Math.max(0, Math.min(this.start.y, this.end.y) - this.outerRadius));
        int yMaxFull = Math.min(640, Math.max(0, Math.max(this.start.y, this.end.y) + this.outerRadius));
        Vec3d dirXz = new Vec3d((double)(this.end.x - this.start.x), 0.0, (double)(this.end.z - this.start.z));
        double lengthXz = dirXz.length();
        dirXz.normalizeLocal();
        Vec3d localStart = this.start.subtract(origin).toVec3d();
        Vec3d dir = this.end.subtract(this.start).toVec3d();
        double length = dir.length();
        dir.normalizeLocal();
        int outerRadiusSq = this.outerRadius * this.outerRadius;
        boolean changed = false;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                int elevation;
                double xRel = (double)(x * spread) - localStart.x;
                double zRel = (double)(z * spread) - localStart.z;
                double project = dirXz.dot(xRel, 0.0, zRel);
                project = this.clamp(project, 0.0, lengthXz);
                Vec3d p = localStart.add(dirXz.mult(project));
                p.y = 0.0;
                double dSq = p.distanceSq((double)(x * spread), 0.0, (double)(z * spread));
                if (dSq > (double)outerRadiusSq || (elevation = terrain.getElevation(x, z)) > yMaxFull || elevation < yMinFull) continue;
                if (simplifiedWay) {
                    terrain.setElevation(x, z, (short)yMinFull);
                    continue;
                }
                if (oldWay) {
                    double yExtent = 0.0;
                    if ((double)outerRadiusSq > dSq) {
                        yExtent = Math.sqrt((double)outerRadiusSq - dSq);
                    }
                    p.set(localStart).addLocal(dir.mult(project * length / lengthXz));
                    int yMin = Math.max(0, (int)Math.floor(p.y - yExtent) + 1);
                    int yMax = Math.min(640, (int)Math.floor(p.y + yExtent) + 1);
                    if (elevation > yMax || elevation < yMin) continue;
                    terrain.setElevation(x, z, (short)yMin);
                    changed = true;
                    continue;
                }
                int yMin = yMinFull;
                int yMax = Math.min(elevation, yMaxFull);
                int newElevation = elevation;
                int y = yMax;
                while (y >= yMin) {
                    double yRel = (double)y - localStart.y;
                    project = dir.dot(xRel, yRel, zRel);
                    project = this.clamp(project, 0.0, length);
                    dSq = (p = p.set(localStart).addLocal(dir.mult(project))).distanceSq((double)x, (double)y, (double)z);
                    if (dSq > (double)outerRadiusSq) break;
                    newElevation = y--;
                }
                if (elevation == newElevation) continue;
                terrain.setElevation(x, z, (short)newElevation);
                changed = true;
            }
        }
        return true;
    }

    public boolean morph(ColumnData colData, Tile tile, Random rand) {
        if (!columnCalcOn) {
            return false;
        }
        Vec3i origin = colData.getColumnId().getWorld(null);
        Vec3d dirXz = this.end.subtract(this.start).toVec3d();
        dirXz.y = 0.0;
        double lengthXz = dirXz.length();
        dirXz.normalizeLocal();
        Vec3d dir = this.end.subtract(this.start).toVec3d();
        double length = dir.length();
        dir.normalizeLocal();
        Vec3d localStart = this.start.subtract(origin).toVec3d();
        int yMin = Math.min(640, Math.max(0, Math.min(this.start.y, this.end.y) - this.outerRadius));
        int yMax = Math.min(640, Math.max(0, Math.max(this.start.y, this.end.y) + this.outerRadius));
        LeafData[] leafs = colData.getLeafs();
        FluidData[] fluid = colData.getFluid();
        int topFluid = FluidUtils.setLevel((int)this.fluidType, (int)6);
        int fullFluid = FluidUtils.setLevel((int)this.fluidType, (int)8);
        double outerRadiusSq = this.outerRadius * this.outerRadius;
        double innerRadiusSq = this.innerRadius * this.innerRadius;
        boolean changed = false;
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                double xRel = (double)x - localStart.x;
                double zRel = (double)z - localStart.z;
                double project = dirXz.dot(xRel, 0.0, zRel);
                if (project < 0.0 || project > lengthXz) {
                    project = this.clamp(project, 0.0, lengthXz);
                }
                Vec3d p = localStart.add(dirXz.mult(project));
                p.y = 0.0;
                double dSq = p.distanceSq((double)x, 0.0, (double)z);
                if (dSq > outerRadiusSq) continue;
                for (int y = yMin; y <= yMax; ++y) {
                    double yRel = (double)y - localStart.y;
                    project = dir.dot(xRel, yRel, zRel);
                    project = this.clamp(project, 0.0, length);
                    dSq = (p = p.set(localStart).addLocal(dir.mult(project))).distanceSq((double)x, (double)y, (double)z);
                    if (dSq > outerRadiusSq) continue;
                    if (dSq >= innerRadiusSq) {
                        double dice;
                        double chance = (dSq - innerRadiusSq) / (outerRadiusSq - innerRadiusSq);
                        switch (curveType) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                chance *= chance;
                                break;
                            }
                            case 2: {
                                chance *= chance * chance;
                                break;
                            }
                            case 3: {
                                chance = this.smoothStep(chance);
                                break;
                            }
                            case 4: {
                                chance = 1.0 - chance;
                                chance *= chance;
                                chance = 1.0 - chance;
                                break;
                            }
                            case 5: {
                                chance = 1.0 - chance;
                                chance *= chance * chance * chance;
                                chance = 1.0 - chance;
                            }
                        }
                        if (chance <= roughnessThreshold || (dice = rand.nextDouble()) < chance) continue;
                    }
                    int layer = y / 32;
                    LeafData leaf = leafs[layer];
                    int j = y % 32;
                    leaf.setCell(x, j, z, 0);
                    if (y < this.fluidLevel) {
                        if (y == this.fluidLevel - 1) {
                            fluid[layer].setCell(x, j, z, topFluid);
                        } else {
                            fluid[layer].setCell(x, j, z, fullFluid);
                        }
                    }
                    changed = true;
                }
            }
        }
        return changed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[start:" + this.start + ", end:" + this.end + ", outerRadius:" + this.outerRadius + ", innerRadius:" + this.innerRadius + "]";
    }
}

