

createType("MarkerMapTool").with {

    addAction("create") { customMarker, name, world, angle ->
        //createCustomMapMarker.call(session, self, customMarker, name, world, angle);
        log.info("create(" + customMarker + ", " + name + ", " + world + ", " + angle + ")");

        TileId tileId = TileId.fromWorld(world);

        def marker = createEntity(
            new OwnedBy(resolveEntityId(activator)),
            new SpawnPosition(world, new Quatd().fromAngles(0, angle, 0)),
            new Name(name),
            customMarker
        );
    }

    addAction("update") { marker, customMarker, name, world, angle ->
        //updateCustomMapMarker.call(session, self, markerId, customMarker, name, world, angle);
        log.info("update(" + marker + ", " + customMarker + ", " + name + ", " + world + ", " + angle + ")");

        // See if we should do it.
        if( marker[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to update:" + marker);
            echo("You do not have permission to do that.");
            return;
        }

        TileId tileId = TileId.fromWorld(world);
        marker << new SpawnPosition(world, new Quatd().fromAngles(0, angle, 0));
        marker << new Name(name);
        marker << customMarker;
    }

    addAction("move") { marker, worldLoc ->
        //moveCustomMapMarker.call(session, self, markerId, worldLoc);
        log.info("move(" + marker + ", " + worldLoc + ")");

        // See if we should do it.
        if( marker[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to move:" + marker);
            echo("You do not have permission to do that.");

            // assert the position back again
            marker << marker[SpawnPosition];
            return;
        }

        def pos = marker[SpawnPosition];
        pos = new SpawnPosition(worldLoc, pos.orientation);
        marker << marker[CustomMapMarker].changePosition(worldLoc);
        marker << pos;

        //echo("Marker moved.");
    }

    addAction("delete") { marker ->
        //deleteCustomMapMarker.call(session, self, markerId);
        log.info("delete(" + marker + ")");

        // See if we should do it.
        if( marker[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to delete:" + marker);
            echo("You do not have permission to do that.");
            return;
        }
        removeEntity(marker);
    }
}


createType("LineMapTool").with {

    addAction("create") { customLine, name ->
        //createCustomMapLine.call(session, self, customLine, name);
        log.info("create(" + customLine + ", " + name + ")");

        def line = createEntity(
            new OwnedBy(resolveEntityId(activator)),
            customLine
        );

        if( name != null ) {
            line << new Name(name);
        }
    }

    addAction("update") { line, customLine, name ->
        //updateCustomMapLine.call(session, self, lineId, customLine, name);
        log.info("update(" + line + ", " + customLine + ", " + name + ")");

        // See if we should do it.
        if( line[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to update:" + line);
            echo("You do not have permission to do that.");
            return;
        }

        line << customLine;

        if( name != null ) {
            line << new Name(name);
        } else {
            line.remove(Name);
        }
    }

    addAction("move") { line, worldLoc1, worldLoc2 ->
        //moveCustomMapLine.call(session, self, lineId, worldLoc1, worldLoc2);
        log.info("move(" + line + ", " + worldLoc1 + ", " + worldLoc2 + ")");

        // See if we should do it.
        if( line[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to move:" + line);
            echo("You do not have permission to do that.");
            line << line[CustomMapLine];
            return;
        }

        def customLine = line[CustomMapLine];
        if( customLine == null ) {
            log.error("Player:" + activator + " tried to move line:" + line + " with no CustomMapLine component");
            line << line[CustomMapLine];
            echo("Error moving line.");
            return;
        }

        line << customLine.move(worldLoc1, worldLoc2);
    }

    addAction("delete") { line ->
        //deleteCustomMapLine.call(session, self, lineId);
        log.info("delete(" + line + ")");
        // See if we should do it.
        if( line[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to delete:" + line);
            echo("You do not have permission to do that.");
            return;
        }
        removeEntity(line);
    }
}


createType("ProtectedAreaMapTool").with {

    addAction("create") { area ->
        //createCustomMapLine.call(session, self, customLine, name);
        log.info("create(" + area + ")");

        def line = createEntity(
            new OwnedBy(resolveEntityId(activator)),
            area
        );
    }

    addAction("update") { entity, area ->
        log.info("update(" + entity + ", " + area + ")");

        // See if we should do it.
        if( entity[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to update:" + entity);
            echo("You do not have permission to do that.");
            return;
        }

        entity << area;
    }

    addAction("move") { entity, worldLoc1, worldLoc2 ->
        log.info("move(" + entity + ", " + worldLoc1 + ", " + worldLoc2 + ")");

        // See if we should do it.
        if( entity[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to move:" + entity);
            echo("You do not have permission to do that.");
            // Force the client to refresh its view
            entity << entity[ProtectedArea];
            return;
        }

        def area = entity[ProtectedArea];
        if( area == null ) {
            log.error("Player:" + activator + " tried to move:" + entity + " with no ProtectedArea component");
            entity << entity[ProtectedArea];
            echo("Error moving line.");
            return;
        }

        entity << area.move(worldLoc1, worldLoc2);
    }

    addAction("delete") { entity ->
        log.info("delete(" + entity + ")");
        // See if we should do it.
        if( entity[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to delete:" + entity);
            echo("You do not have permission to do that.");
            return;
        }
        removeEntity(entity);
    }
}


def versionKey = "map.tools.version";
def version = worldManager.worldEntity.vars.loadInt(versionKey, -1);
def latestVersion = 1;

if( version < 0 ) {
    log.info("Cleaning up old unowned map tools.");
    findEntities(null, ObjectName.class, MapToolType.class).each {
        if( it[OwnedBy] == null ) {
            log.info("Removing:" + it);
            logComponents(log, it, "    ", 80);
            removeEntity(it);
        }
    }
}

if( version < latestVersion ) {
    // Mark it as upgraded
    log.info("Setting " + versionKey + " to:" + latestVersion);
    worldManager.worldEntity.vars.storeInt(versionKey, latestVersion);
}


createMapTool = { EntityId parent, String name, MapToolType tool ->
    def entity = findEntity(OwnedBy.filter(parent), ObjectName.filter(name),
                            MapToolType.class, ObjectTypeInfo.class);
    if( !entity ) {
        log.info("Creating new tool for:" + name);
        entity = createEntity();
    } else {
        log.info("Reusing existing tool for:" + name);
    }
    entity << new OwnedBy(parent);
    entity << tool;
    entity << ObjectName.create(name);
    entity << ObjectTypeInfo.create(name.replace(" ", "") + "MapTool");
    return entity;
}


// Add the default map tools for players
if( true ) {

    if( false ) {
        // Some cleanup when I goof up
        findEntities(MapToolType.class).each {
            log.info("Removing map tool:" + it[MapToolType]);
            removeEntity(it);
        }
    }

    // Global tools and icons are owned by the world entity
    def parent = worldManager.worldEntity;

    def tools = [
        //"Select":MapToolType.create("select", "/Interface/select-icon.png"),
        "Measure":MapToolType.create("measure", "/Interface/measure-icon.png"),
        "Marker":MapToolType.create("marker", "/Interface/flag-icon.png"),
        "Line":MapToolType.create("line", "/Interface/line-icon.png")
    ];

    tools.entrySet().each { entry ->
        createMapTool(parent, entry.key, entry.value);
    }

    // Icon set defined by markers that are owned by the world entity

    // Delete the existing icon set
    findEntities(OwnedBy.filter(parent), OwnedBy.class, CustomMapMarker.class).each {
        log.info("Removing icon:" + it[CustomMapMarker]);
        removeEntity(it);
    }

    def loc = new Vec3d(0,0,0);
    def icons = [
        "a) X":CustomMapMarker.create("/Interface/marker-icons.png(2,7)", 0, 0, loc),
        "b) Star":CustomMapMarker.create("/Interface/marker-icons.png(3,7)", 0, 0, loc),
        "c) House":CustomMapMarker.create("/Interface/marker-icons.png(3,6)", 0, 0, loc),
        "d) Henge":CustomMapMarker.create("/Interface/marker-icons.png(4,6)", 0, 0, loc),
        "e) Arch":CustomMapMarker.create("/Interface/marker-icons.png(1,6)", 0, 0, loc),
        "f) Castle":CustomMapMarker.create("/Interface/marker-icons.png(2,6)", 0, 0, loc),
        "g) Dungeon":CustomMapMarker.create("/Interface/marker-icons.png(0,6)", 0, 0, loc),
        "h) Paw Print":CustomMapMarker.create("/Interface/marker-icons.png(1,7)", 0, 0, loc),
        "i) Leaf":CustomMapMarker.create("/Interface/marker-icons.png(4,7)", 0, 0, loc),
        "j) Apple":CustomMapMarker.create("/Interface/marker-icons.png(0,7)", 0, 0, loc),
        "k) Meat":CustomMapMarker.create("/Interface/marker-icons.png(5,7)", 0, 0, loc),
        "l) Potion":CustomMapMarker.create("/Interface/marker-icons.png(6,7)", 0, 0, loc),
        "m) Bottle":CustomMapMarker.create("/Interface/marker-icons.png(7,7)", 0, 0, loc)
    ]

    icons.entrySet().each { entry ->
        String s = entry.key;
        def comp = entry.value;

        def criteria = new EntityCriteria();
        criteria.add(OwnedBy.filter(parent));
        criteria.add(ObjectName.filter(s));
        criteria.add(CustomMapMarker.class);

        def existing = findEntity2(criteria);
        if( !existing ) {
            existing = createEntity();
        }

        existing << comp;
        existing << ObjectName.create(s);
        existing << new OwnedBy(parent);
    }

    def end1 = new Vec3d(0, -1, 0);
    def end2 = new Vec3d(1, -1, 0);
    def lines = [
        "Thin":CustomMapLine.create(end1, end2, "/Interface/line-styles.png(0,7)", entityData),
        "Thick":CustomMapLine.create(end1, end2, "/Interface/line-styles.png(0,6)", entityData),
        "Double":CustomMapLine.create(end1, end2, "/Interface/line-styles.png(0,5)", entityData),
        "Chain":CustomMapLine.create(end1, end2, "/Interface/line-styles.png(0,4)", entityData)
    ]

    lines.entrySet().each { entry ->
        String s = entry.key;
        def comp = entry.value;

        def criteria = new EntityCriteria()
                    .add(OwnedBy.filter(parent))
                    .add(ObjectName.filter(s))
                    .add(CustomMapLine.class);

        def existing = findEntity2(criteria);
        if( !existing ) {
            existing = createEntity();
        }

        existing << comp;
        existing << ObjectName.create(s);
        existing << new OwnedBy(parent);
    }
}

import mythruna.net.server.AccountHostedService;
import mythruna.net.server.GameSessionHostedService;

def adminTools = [
    "Protected Area":MapToolType.create("protect", "/Interface/box-icon.png")
];

// Player specific tools if they are an admin
on( playerEntityJoining ) { event ->

    // Always start player tools off fresh
    findEntities(OwnedBy.filter(event.player), MapToolType.class).each {
        log.info("Removing player's map tool:" + it[MapToolType]);
        removeEntity(it);
    }

    def account = AccountHostedService.getAccount(event.connection);
    if( account ) {
        log.info("Entity joined for account:" + account);

        def perms = account.getProperty("permissions", List.class);
        if( singlePlayer || perms?.contains("admin") ) {

            def shell = GameSessionHostedService.getShell(event.connection);
            def cmdHelp = [
                "- Enabled the map admin tools."
            ];
            addShellCommand(shell, "mapAdmin", cmdHelp) {
                //// Add the admin-only map tools
                def parent = event.player;

                adminTools.entrySet().each { entry ->
                    shell.echo("Enabling map tool:" + entry.key);
                    def entity = createMapTool(parent, entry.key, entry.value);
                    logComponents(log, entity, "    ", 80);
                }
            }
        }
    }

}


