/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.morph.AbstractMorphology;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBoxMorphology
extends AbstractMorphology {
    static Logger log = LoggerFactory.getLogger(AbstractBoxMorphology.class);
    private Vec3i min;
    private Vec3i max;

    protected AbstractBoxMorphology(Vec3i min, Vec3i max) {
        this.min = min;
        this.max = max;
    }

    protected Vec3i getMin() {
        return this.min;
    }

    protected Vec3i getMax() {
        return this.max;
    }

    @Override
    public Iterable<Short> getAffectedColumns(TileId tileId) {
        ArrayList<Short> results = new ArrayList<Short>();
        Vec3i origin = tileId.getWorld(null);
        int xMin = this.min.x - origin.x;
        int zMin = this.min.z - origin.z;
        int xMax = this.max.x - origin.x;
        int zMax = this.max.z - origin.z;
        if (xMax < 0 || zMax < 0) {
            return results;
        }
        if (xMin >= 1024 || zMin >= 1024) {
            return results;
        }
        xMin = Math.max(0, xMin);
        xMax = Math.min(xMax, 1023);
        zMin = Math.max(0, zMin);
        zMax = Math.min(zMax, 1023);
        Vec3i min = ColumnId.GRID.worldToCell((double)xMin, 0.0, (double)zMin);
        Vec3i max = ColumnId.GRID.worldToCell((double)xMax, 0.0, (double)zMax);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                short id = ColumnId.toTileLocalIndexId(x, z);
                results.add(id);
                ColumnId colId = ColumnId.fromTileLocalIndex(tileId, x, z);
                if (tileId.getId() == colId.getTileId().getId()) continue;
                log.warn("Tile mismatch for (" + x + ", " + z + ") tile:" + tileId + "  min:" + min + "  max:" + max);
            }
        }
        return results;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[min:" + this.min + ", max:" + this.max + "]";
    }
}

