/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.geom.TbtQuad;
import com.simsilica.mathd.Vec3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grid
extends Node {
    static Logger log = LoggerFactory.getLogger(Grid.class);
    private static final ColorRGBA DEFAULT_GRID_COLOR = new ColorRGBA(0.8156863f, 0.7607843f, 0.60784316f, 0.25f);
    private int width;
    private int height;
    private float cellSize;
    private float borderSize = 10.0f;
    private ColorRGBA gradientColor = new ColorRGBA(0.34901962f, 0.3019608f, 0.20392157f, 0.8f);
    private ColorRGBA borderColor = new ColorRGBA(0.8156863f, 0.7607843f, 0.60784316f, 1.0f);
    private boolean active;
    private ColorRGBA gridColor = DEFAULT_GRID_COLOR;
    private ColorRGBA activeColor = new ColorRGBA(0.40784314f, 0.38039216f, 0.3019608f, 0.5f);
    private Spatial gridPanel;
    private GuiMaterial gridMaterial;
    private Spatial gradient;
    private Spatial border;
    private boolean enabled = true;

    public Grid(int width, int height, float cellSize, float borderSize) {
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.borderSize = borderSize;
        Quad gradientQuad = new Quad((float)width * cellSize, (float)height * cellSize);
        Texture texture = GuiGlobals.getInstance().loadTexture("Interface/dip-gradient.png", false, false);
        GuiMaterial mat = GuiGlobals.getInstance().createMaterial(texture, false);
        Geometry geom = new Geometry("Gradient", (Mesh)gradientQuad);
        this.gradient = geom;
        geom.setMaterial(mat.getMaterial());
        mat.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.getMaterial().getAdditionalRenderState().setDepthWrite(false);
        mat.getMaterial().setColor("Color", this.gradientColor);
        geom.setUserData("layer", (Object)1);
        geom.move(0.0f, (float)(-height) * cellSize, 0.0f);
        this.attachChild((Spatial)geom);
        Quad grid = new Quad((float)width * cellSize, (float)height * cellSize);
        grid.scaleTextureCoordinates(new Vector2f((float)width, (float)height));
        texture = GuiGlobals.getInstance().loadTexture("Interface/grid-cell-64.png", true, false);
        this.gridMaterial = mat = GuiGlobals.getInstance().createMaterial(texture, false);
        geom = new Geometry("Grid", (Mesh)grid);
        this.gridPanel = geom;
        geom.setMaterial(mat.getMaterial());
        mat.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.getMaterial().setColor("Color", this.gridColor);
        geom.setUserData("layer", (Object)2);
        geom.move(0.0f, (float)(-height) * cellSize, 0.0f);
        this.attachChild((Spatial)geom);
        TbtQuad borderQuad = new TbtQuad(borderSize + (float)width * cellSize, borderSize + (float)height * cellSize, 48, 48, 80, 80, 128, 128, borderSize / 2.0f / 32.0f);
        texture = GuiGlobals.getInstance().loadTexture("Interface/bevel-border.png", false, false);
        mat = GuiGlobals.getInstance().createMaterial(texture, false);
        geom = new Geometry("Border", (Mesh)borderQuad);
        this.border = geom;
        geom.setMaterial(mat.getMaterial());
        mat.getMaterial().setColor("Color", this.borderColor);
        mat.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geom.setLocalTranslation(-borderSize * 0.5f, -borderSize * 0.5f, 0.0f);
        geom.setUserData("layer", (Object)3);
        geom.move(0.0f, (float)(-height) * cellSize, 0.0f);
        this.attachChild((Spatial)geom);
        this.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.updateColor();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.attachChild(this.gradient);
            this.attachChild(this.gridPanel);
            this.attachChild(this.border);
        } else {
            this.gradient.removeFromParent();
            this.gridPanel.removeFromParent();
            this.border.removeFromParent();
        }
    }

    public void setGridColor(ColorRGBA gridColor) {
        this.gridColor = gridColor != null ? gridColor : DEFAULT_GRID_COLOR;
        this.updateColor();
    }

    public void setActiveColor(ColorRGBA activeColor) {
        this.activeColor = activeColor != null ? activeColor : DEFAULT_GRID_COLOR;
        this.updateColor();
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.updateColor();
    }

    protected void updateColor() {
        if (this.active) {
            this.gridMaterial.setColor(this.activeColor);
        } else {
            this.gridMaterial.setColor(this.gridColor);
        }
    }

    public Vec3d getSize() {
        return new Vec3d((double)((float)this.width * this.cellSize), (double)((float)this.height * this.cellSize), 0.0);
    }

    public Spatial getGridPanel() {
        return this.gridPanel;
    }
}

