/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.material.MatParamOverride;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.SafeCellData;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.CellArrayPart;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialUtils {
    static Logger log = LoggerFactory.getLogger(SpatialUtils.class);

    public static Spatial findOidSpatial(Spatial spatial) {
        Long oid = (Long)spatial.getUserData("oid");
        if (oid != null) {
            return spatial;
        }
        if (spatial.getParent() != null) {
            return SpatialUtils.findOidSpatial((Spatial)spatial.getParent());
        }
        return null;
    }

    public static boolean isCarved(String name) {
        if (name == null) {
            return false;
        }
        if (name.endsWith(".ca") && name.startsWith("c_")) {
            return true;
        }
        if (name.endsWith(".carved.blocks")) {
            return true;
        }
        return name.endsWith(".fax");
    }

    public static Spatial createCellArrayPart(CellArrayPart part, GeometryFactory geomFactory) {
        Node parts = new Node("parts:" + part.getName());
        CellArray cells = part.getCells();
        CellArray lights = new CellArray(cells.getSizeX(), cells.getSizeY(), cells.getSizeZ());
        LightUtils.recalculateLighting((CellData)cells, (CellData)lights, (int)0, (int)0, (int)0, (int)lights.getSizeX(), (int)lights.getSizeY(), (int)lights.getSizeZ());
        SafeCellData safeLights = new SafeCellData((CellData)lights, LightUtils.DIRECT_SUN);
        geomFactory.generateBlocks(parts, cells, (CellData)safeLights, true);
        parts.setLocalScale((float)part.getScale());
        parts.setLocalTranslation(part.getLocalPosition().toVector3f());
        parts.setLocalRotation(part.getLocalOrientation().toQuaternion());
        parts.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        return parts;
    }

    public static Spatial createCellArraySpatial(String name, CellArray cells, double scale, GeometryFactory geomFactory, boolean castShadows, Predicate<Geometry> carveIncludes) {
        Node parts = new Node("cells:" + name);
        CellArray lights = new CellArray(cells.getSizeX(), cells.getSizeY(), cells.getSizeZ());
        LightUtils.recalculateLighting((CellData)cells, (CellData)lights, (int)0, (int)0, (int)0, (int)lights.getSizeX(), (int)lights.getSizeY(), (int)lights.getSizeZ());
        SafeCellData safeLights = new SafeCellData((CellData)lights, LightUtils.DIRECT_SUN);
        geomFactory.generateBlocks(parts, cells, (CellData)safeLights, true);
        parts.setLocalScale((float)scale);
        if (carveIncludes != null) {
            float carveScale = (float)(1.0 / scale);
            parts.addMatParamOverride(new MatParamOverride(VarType.Float, "CarveScale", (Object)Float.valueOf(carveScale)));
        }
        if (castShadows) {
            parts.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        }
        return parts;
    }

    public static Spatial createDebugSphere(String name, float radius, ColorRGBA color, String textureName) {
        Sphere mesh = new Sphere(24, 24, radius);
        mesh.setTextureMode(Sphere.TextureMode.Projected);
        mesh.scaleTextureCoordinates(new Vector2f(4.0f, 2.0f));
        Geometry geom = new Geometry(name, (Mesh)mesh);
        geom.setMaterial(GuiGlobals.getInstance().createMaterial(color, true).getMaterial());
        if (textureName != null) {
            Texture texture = GuiGlobals.getInstance().loadTexture(textureName, true, true);
            geom.getMaterial().setTexture("DiffuseMap", texture);
        }
        geom.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        return geom;
    }

    public static Geometry createDebugBox(String name, float size, ColorRGBA color) {
        Box box = new Box(size, size, size);
        Geometry geom = new Geometry(name, (Mesh)box);
        geom.setMaterial(GuiGlobals.getInstance().createMaterial(color, false).getMaterial());
        geom.getMaterial().getAdditionalRenderState().setWireframe(true);
        geom.getMaterial().getAdditionalRenderState().setDepthTest(false);
        geom.setQueueBucket(RenderQueue.Bucket.Translucent);
        return geom;
    }
}

