/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.input;

import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.simsilica.input.AbstractMovementTarget;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;

public class CameraMovementTarget
extends AbstractMovementTarget {
    private Camera camera;
    private boolean relativeForward = true;
    private boolean relativeUp = true;

    public CameraMovementTarget(Camera camera) {
        if (camera == null) {
            throw new IllegalArgumentException("Camera cannot be null");
        }
        this.camera = camera;
    }

    public void setRelativeForward(boolean relativeForward) {
        this.relativeForward = relativeForward;
    }

    public boolean isRelativeForward() {
        return this.relativeForward;
    }

    public void setRelativeUp(boolean relativeUp) {
        this.relativeUp = relativeUp;
    }

    public boolean isRelativeUp() {
        return this.relativeUp;
    }

    @Override
    public void move(Quatd rotation, Vec3d movementForces, double tpf) {
        if (movementForces.lengthSq() == 0.0) {
            return;
        }
        Vector3f loc = this.camera.getLocation();
        if (this.relativeUp && this.relativeForward) {
            loc.addLocal(rotation.mult(movementForces).multLocal(tpf).toVector3f());
        } else {
            Vec3d move = new Vec3d();
            if (this.relativeForward) {
                move.addLocal(rotation.mult(Vec3d.UNIT_Z).multLocal(movementForces.z * tpf));
            } else {
                Vec3d dir = rotation.mult(Vec3d.UNIT_Z);
                dir.y = 0.0;
                dir.normalizeLocal();
                move.addLocal(dir.multLocal(movementForces.z * tpf));
            }
            move.addLocal(rotation.mult(Vec3d.UNIT_X).multLocal(movementForces.x * tpf));
            if (this.relativeUp) {
                move.addLocal(rotation.mult(Vec3d.UNIT_Y).multLocal(movementForces.y * tpf));
            } else {
                move.addLocal(0.0, movementForces.y * tpf, 0.0);
            }
            loc.addLocal(move.toVector3f());
        }
        this.camera.setLocation(loc);
    }

    @Override
    public void setRotation(Quatd rotation) {
        this.camera.setRotation(rotation.toQuaternion());
    }

    @Override
    public Quatd getRotation() {
        return new Quatd(this.camera.getRotation());
    }
}

