/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.Filters;
import com.simsilica.es.IndexedField;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedArea
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(ProtectedArea.class);
    private Vec3d min;
    private Vec3d max;
    private int type;
    @IndexedField
    private long neTileId;
    @IndexedField
    private long seTileId;
    @IndexedField
    private long swTileId;
    @IndexedField
    private long nwTileId;

    private ProtectedArea() {
    }

    public ProtectedArea(Vec3d end1, Vec3d end2, int type) {
        double y = end1.y;
        double x1 = Math.min(end1.x, end2.x);
        double x2 = Math.max(end1.x, end2.x);
        double z1 = Math.min(end1.z, end2.z);
        double z2 = Math.max(end1.z, end2.z);
        this.neTileId = TileId.fromWorld((double)x2, (double)y, (double)z2).getId();
        this.seTileId = TileId.fromWorld((double)x2, (double)y, (double)z1).getId();
        this.swTileId = TileId.fromWorld((double)x1, (double)y, (double)z1).getId();
        this.nwTileId = TileId.fromWorld((double)x1, (double)y, (double)z2).getId();
        this.min = new Vec3d(x1, y, z1);
        this.max = new Vec3d(x2, y, z2);
        this.type = type;
    }

    public static ProtectedArea create(Vec3d end1, Vec3d end2, int type) {
        return new ProtectedArea(end1, end2, type);
    }

    public static ComponentFilter<ProtectedArea> filterTileId(long tileId) {
        ComponentFilter f1 = Filters.fieldEquals(ProtectedArea.class, (String)"neTileId", (Object)tileId);
        ComponentFilter f2 = Filters.fieldEquals(ProtectedArea.class, (String)"seTileId", (Object)tileId);
        ComponentFilter f3 = Filters.fieldEquals(ProtectedArea.class, (String)"swTileId", (Object)tileId);
        ComponentFilter f4 = Filters.fieldEquals(ProtectedArea.class, (String)"nwTileId", (Object)tileId);
        return Filters.or(ProtectedArea.class, (ComponentFilter[])new ComponentFilter[]{f1, f2, f3, f4});
    }

    public ProtectedArea move(Vec3d end1, Vec3d end2) {
        return new ProtectedArea(end1, end2, this.type);
    }

    public Vec3d getMin() {
        return this.min;
    }

    public Vec3d getMax() {
        return this.max;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("min", (Object)this.min).add("max", (Object)this.max).add("type", this.type).toString();
    }
}

