/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.client;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.es.EntityId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import mythruna.net.AccountListener;
import mythruna.net.AccountSession;
import mythruna.net.DefaultAccountListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountClientService
extends AbstractClientService
implements AccountSession {
    static Logger log = LoggerFactory.getLogger(AccountClientService.class);
    private RmiClientService rmiService;
    private int channel;
    private AccountSession delegate;
    private EntityId userEntity;
    private EntityId worldEntity;
    private AccountSessionCallback sessionCallback = new AccountSessionCallback();
    private List<AccountListener> listeners = new CopyOnWriteArrayList<AccountListener>();

    public AccountClientService() {
        this(-2);
    }

    public AccountClientService(int channel) {
        this.channel = channel;
    }

    protected void threadCheck() {
        if ("jME3 Main".equals(Thread.currentThread().getName())) {
            log.warn("long-style query, cache miss on render thread", new Throwable("stack-trace"));
        }
    }

    @Override
    public void knock() {
        this.getDelegate().knock();
    }

    @Override
    public void login(String userId, Map<String, Object> credentials) {
        this.userEntity = null;
        this.worldEntity = null;
        this.getDelegate().login(userId, credentials);
    }

    @Override
    public void createAccount(String userId, Map<String, Object> credentials) {
        this.getDelegate().createAccount(userId, credentials);
    }

    public void createAccount(String userId, Map<String, Object> credentials, final BiConsumer<Boolean, String> callback) {
        this.listeners.add(new DefaultAccountListener(){

            @Override
            public void accountStatus(boolean success, String message) {
                callback.accept(success, message);
                AccountClientService.this.listeners.remove(this);
            }
        });
        this.createAccount(userId, credentials);
    }

    @Override
    public EntityId getUserEntity() {
        if (this.userEntity == null) {
            this.threadCheck();
            this.userEntity = this.getDelegate().getUserEntity();
        }
        return this.userEntity;
    }

    @Override
    public void enterWorld(EntityId character) {
        this.threadCheck();
        this.getDelegate().enterWorld(character);
    }

    @Override
    public EntityId getWorldEntity() {
        if (this.worldEntity == null) {
            this.threadCheck();
            this.worldEntity = this.getDelegate().getWorldEntity();
        }
        return this.worldEntity;
    }

    public void addAccountListener(AccountListener l) {
        this.listeners.add(l);
    }

    public void removeAccountListener(AccountListener l) {
        this.listeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.debug("onInitialize(" + s + ")");
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("ChatClientService requires RMI service");
        }
        log.debug("Sharing session callback.");
        this.rmiService.share((byte)this.channel, (Object)this.sessionCallback, AccountListener.class);
    }

    public void start() {
        log.debug("start()");
        super.start();
        this.getDelegate().knock();
    }

    private AccountSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (AccountSession)this.rmiService.getRemoteObject(AccountSession.class);
            log.debug("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No account session found");
            }
        }
        return this.delegate;
    }

    private class AccountSessionCallback
    implements AccountListener {
        private AccountSessionCallback() {
        }

        @Override
        public void challenge(String randomSalt, List<String> caps) {
            if (log.isTraceEnabled()) {
                log.trace("challenge(" + caps + ")");
            }
            for (AccountListener l : AccountClientService.this.listeners) {
                l.challenge(randomSalt, caps);
            }
        }

        @Override
        public void loginStatus(boolean loggedIn, String message) {
            if (log.isTraceEnabled()) {
                log.trace("loginStatus(" + loggedIn + ", " + message + ")");
            }
            for (AccountListener l : AccountClientService.this.listeners) {
                l.loginStatus(loggedIn, message);
            }
        }

        @Override
        public void accountStatus(boolean success, String message) {
            if (log.isTraceEnabled()) {
                log.trace("accountStatus(" + success + ", " + message + ")");
            }
            for (AccountListener l : AccountClientService.this.listeners) {
                l.accountStatus(success, message);
            }
        }
    }
}

