/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.path;

import java.util.function.Consumer;
import mythruna.world.path.NodeVisitor;
import mythruna.world.path.Path;
import mythruna.world.path.PathNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeVisitors {
    static Logger log = LoggerFactory.getLogger(NodeVisitors.class);

    public static NodeVisitor preOrder(Consumer<PathNode> visitor) {
        return new ConsumerNodeVisitorAdapter(visitor, null);
    }

    public static NodeVisitor postOrder(Consumer<PathNode> visitor) {
        return new ConsumerNodeVisitorAdapter(null, visitor);
    }

    protected static class ConsumerNodeVisitorAdapter
    implements NodeVisitor {
        private Consumer<PathNode> preVisitor;
        private Consumer<PathNode> postVisitor;

        public ConsumerNodeVisitorAdapter(Consumer<PathNode> preVisitor, Consumer<PathNode> postVisitor) {
            this.preVisitor = preVisitor;
            this.postVisitor = postVisitor;
        }

        @Override
        public boolean preVisit(Path traversed, PathNode node) {
            if (this.preVisitor != null) {
                this.preVisitor.accept(node);
            }
            return true;
        }

        @Override
        public void postVisit(Path traversed, PathNode node) {
            if (this.postVisitor != null) {
                this.postVisitor.accept(node);
            }
        }
    }
}

