/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.mathd.Vec3d;
import mythruna.client.ui.map.MapLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRootComponent
extends AbstractGuiComponent
implements MapLayer {
    static Logger log = LoggerFactory.getLogger(MapRootComponent.class);
    private Node layerRoot;
    private Vector3f layerSize = new Vector3f(1.0f, 1.0f, 1.0f);
    private VersionedHolder<Double> scale = new VersionedHolder((Object)1.0);
    private VersionedHolder<Vec3d> worldCenter = new VersionedHolder((Object)new Vec3d());
    private double worldRadius = 7680.0;

    public MapRootComponent() {
        this("mapRoot");
    }

    public MapRootComponent(String name) {
        this.layerRoot = new Node(name);
    }

    public Node getLayerRoot() {
        return this.layerRoot;
    }

    public Vector3f getLayerSize() {
        return this.layerSize;
    }

    @Override
    public void setWorldCenter(Vec3d worldCenter) {
        ((Vec3d)this.worldCenter.getObject()).set(worldCenter);
        this.worldCenter.incrementVersion();
    }

    public VersionedObject<Vec3d> getWorldCenter() {
        return this.worldCenter;
    }

    @Override
    public void setWorldRadius(double worldRadius) {
        this.worldRadius = worldRadius;
        this.recalculateScale();
    }

    public double getWorldRadius() {
        return this.worldRadius;
    }

    public double getWorldToLocalScale() {
        return (Double)this.scale.getObject();
    }

    public VersionedObject<Double> getScale() {
        return this.scale;
    }

    protected void recalculateScale() {
        double screenWidth = this.layerSize.x;
        double worldWidth = this.worldRadius * 2.0;
        this.scale.updateObject((Object)(screenWidth / worldWidth));
    }

    public Vec3d viewToWorld(Vector3f view) {
        double xViewCenter = (double)this.layerSize.x * 0.5;
        double yViewCenter = (double)this.layerSize.y * 0.5;
        double x = (double)view.x - xViewCenter;
        double y = (double)(-view.y) - yViewCenter;
        double s = (Double)this.scale.getObject();
        return ((Vec3d)this.worldCenter.getObject()).add(x / s, 0.0, y / s);
    }

    public void attach(GuiControl parent) {
        super.attach(parent);
        if (this.layerRoot != null) {
            this.getNode().attachChild((Spatial)this.layerRoot);
        }
    }

    public void detach(GuiControl parent) {
        if (this.layerRoot != null) {
            this.getNode().detachChild((Spatial)this.layerRoot);
        }
        super.detach(parent);
    }

    public void calculatePreferredSize(Vector3f size) {
    }

    public void reshape(Vector3f pos, Vector3f size) {
        this.layerRoot.setLocalTranslation(pos.x + size.x * 0.5f, pos.y - size.y * 0.5f, pos.z);
        this.layerSize.set(size);
        this.recalculateScale();
    }
}

