/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.texture.Texture;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.pc.PointType;
import com.simsilica.mworld.view.MaterialFactories;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainMaterials {
    static Logger log = LoggerFactory.getLogger(TerrainMaterials.class);
    private static final ColorRGBA groundColor = new ColorRGBA(0.11764706f, 0.39215687f, 0.11764706f, 1.0f);
    private static final ColorRGBA waterColor = new ColorRGBA(0.09411765f, 0.33333334f, 0.8039216f, 0.9f);
    private static boolean debug = false;

    public static Function<TerrainImageType, Material> terrainMaterial(Application app) {
        return type -> {
            String matDef = "MatDefs/terrain/MythrunaTerrain.j3md";
            ColorRGBA color = groundColor;
            if (type == TerrainImageType.Fluid) {
                color = waterColor;
            }
            Material mat = new Material(app.getAssetManager(), matDef);
            mat.setBoolean("UseMaterialColors", true);
            mat.setColor("Diffuse", color);
            mat.setColor("Ambient", ColorRGBA.White);
            if (color.a < 1.0f) {
                mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            }
            if (type != TerrainImageType.Fluid) {
                mat.setBoolean("CalculateNormals", true);
                Texture atlas = app.getAssetManager().loadTexture(new TextureKey("Textures/terrain-atlas-flattened.png", false));
                atlas.setWrap(Texture.WrapMode.Repeat);
                mat.setTexture("DiffuseAtlas", atlas);
            } else {
                mat.setBoolean("IsFluid", true);
            }
            return mat;
        };
    }

    public static Function<TerrainImageType, Material> farTerrainMaterial(Application app) {
        return type -> {
            ColorRGBA color = groundColor;
            if (type == TerrainImageType.Fluid) {
                color = waterColor;
            }
            Material mat = new Material(app.getAssetManager(), "MatDefs/terrain/MythrunaTerrain.j3md");
            mat.setBoolean("UseMaterialColors", true);
            mat.setColor("Diffuse", color);
            mat.setColor("Ambient", color);
            if (type != TerrainImageType.Fluid) {
                mat.setBoolean("CalculateNormals", true);
                Texture atlas = app.getAssetManager().loadTexture(new TextureKey("Textures/terrain-atlas-flattened.png", false));
                atlas.setWrap(Texture.WrapMode.Repeat);
                mat.setTexture("DiffuseAtlas", atlas);
            } else {
                mat.setBoolean("IsFluid", true);
            }
            if (color.a < 1.0f) {
                mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            }
            return mat;
        };
    }

    public static Function<String, Material> treeBillboardMaterial(Application app) {
        return atlasName -> {
            Material mat = (Material)MaterialFactories.treeBillboardMaterial((Application)app).apply(atlasName);
            if (debug) {
                mat.setColor("Diffuse", new ColorRGBA(1.0f, 0.1f, 0.1f, 1.0f));
                mat.setColor("Ambient", new ColorRGBA(0.1f, 0.1f, 1.0f, 1.0f));
                mat.setBoolean("UseFog", false);
            } else {
                mat.setColor("Diffuse", new ColorRGBA(1.2f, 1.2f, 1.2f, 1.0f));
                mat.setColor("Ambient", new ColorRGBA(0.1f, 0.1f, 0.1f, 1.0f));
            }
            return mat;
        };
    }

    public static Function<PointType, Material> pointCloudMaterial(Application app) {
        return type -> {
            Material mat = (Material)MaterialFactories.pointCloudMaterial((Application)app).apply(type);
            Texture atlas = app.getAssetManager().loadTexture("Textures/palette-blocks.png");
            atlas.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
            atlas.setMagFilter(Texture.MagFilter.Nearest);
            mat.setTexture("ColorMap", atlas);
            return mat;
        };
    }
}

