/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import java.util.Arrays;
import java.util.Random;
import org.progeeks.map.AbstractElevationGenerator;
import org.progeeks.map.ElevationData;

public class DiamondSquaresElevations
extends AbstractElevationGenerator {
    private double roughness = 3.0;
    private int roughnessBias = 5;
    private int seed;
    private int preseedFactor = 2;

    public DiamondSquaresElevations() {
        super("Diamond/Squares");
        this.setElevationScale(16500);
    }

    public void setSeed(int seed) {
        if (this.seed == seed) {
            return;
        }
        this.seed = seed;
        this.invalidate();
    }

    public int getSeed() {
        return this.seed;
    }

    public void setPreseedFrequency(int s) {
        int mapSize = this.getSourceData().getMapSize();
        int seedMax = (int)Math.round(Math.log(mapSize) / Math.log(2.0));
        if (s > seedMax) {
            s = seedMax;
        } else if (s < 0) {
            s = 0;
        }
        if (this.preseedFactor == s) {
            return;
        }
        this.preseedFactor = s;
        this.invalidate();
    }

    public int getPreseedFrequency() {
        return this.preseedFactor;
    }

    public void setRoughnessScale(double r) {
        if (this.roughness == r) {
            return;
        }
        this.roughness = r;
        this.invalidate();
    }

    public double getRoughnessScale() {
        return this.roughness;
    }

    public void setRoughnessBias(int bias) {
        if (this.roughnessBias == bias) {
            return;
        }
        this.roughnessBias = bias;
        this.invalidate();
    }

    public int getRoughnessBias() {
        return this.roughnessBias;
    }

    @Override
    protected ElevationData generateElevations(ElevationData result) {
        ElevationData source = this.getSourceData();
        int[][] sourceMap = source.getElevations();
        int mapSize = source.getMapSize();
        if (result == null) {
            result = new ElevationData(mapSize);
        }
        result.setElevationScale(this.getElevationScale());
        result.setElevationOffset(this.getElevationOffset());
        int sourceScale = source.getElevationScale();
        int sourceOffset = source.getElevationOffset();
        int scale = this.getElevationScale();
        int offset = this.getElevationOffset();
        int[][] map = result.getElevations();
        Random rand = new Random(this.getSeed());
        for (int y = 0; y <= mapSize; ++y) {
            Arrays.fill(map[y], offset);
        }
        int heightRange = scale;
        int maxHeight = scale - offset;
        int seedMax = (int)Math.round(Math.log(mapSize) / Math.log(2.0));
        int seedStep = seedMax - this.preseedFactor;
        seedStep = (int)Math.pow(2.0, seedStep);
        for (int x = 0; x <= mapSize; x += seedStep) {
            for (int y = 0; y <= mapSize; y += seedStep) {
                if (y == 0 || x == 0 || x == mapSize || y == mapSize) continue;
                map[y][x] = sourceMap[y][x] != 0 ? sourceMap[y][x] : offset + rand.nextInt(scale);
            }
        }
        double cos45 = Math.cos(Math.toRadians(45.0));
        int step = seedStep;
        double displacement = (double)(scale / 2) * this.roughness;
        double count = Math.log(step) / Math.log(2.0);
        double displacementStep = Math.exp(Math.log(displacement) / (count += (double)this.roughnessBias));
        boolean doElevFactor = false;
        while (step > 1) {
            int rise;
            int halfStep = step / 2;
            int squareDisp = (int)displacement;
            int halfSqDisp = squareDisp / 2;
            for (int x = 0; x < mapSize; x += step) {
                for (int y = 0; y < mapSize; y += step) {
                    int nw = map[y][x];
                    int ne = map[y][x + step];
                    int sw = map[y + step][x];
                    int se = map[y + step][x + step];
                    int average = (nw + ne + sw + se) / 4;
                    int d = squareDisp;
                    if (doElevFactor) {
                        int eFactor = maxHeight * 2 / 3 + average * 1 / 3;
                        d = d * eFactor / maxHeight;
                    }
                    int hd = d >> 1;
                    rise = d > 0 ? rand.nextInt(d) - hd : 0;
                    map[y + halfStep][x + halfStep] = average + rise;
                }
            }
            int diamondDisp = (int)Math.round(displacement * cos45);
            int halfDmdDisp = diamondDisp / 2;
            for (int x = 0; x < mapSize; x += step) {
                for (int y = 0; y < mapSize; y += step) {
                    int d;
                    int average;
                    int rise2;
                    int hd;
                    int eFactor;
                    int d2;
                    int average2;
                    int w;
                    int e;
                    int s;
                    int n;
                    int previous;
                    if (y > 0) {
                        previous = y - halfStep;
                        n = map[previous][x + halfStep];
                        s = map[y + halfStep][x + halfStep];
                        e = map[y][x + step];
                        w = map[y][x];
                        average2 = (n + s + e + w) / 4;
                        d2 = diamondDisp;
                        if (doElevFactor) {
                            eFactor = maxHeight * 2 / 3 + average2 * 1 / 3;
                            d2 = d2 * eFactor / maxHeight;
                        }
                        hd = d2 >> 1;
                        rise2 = d2 > 0 ? rand.nextInt(d2) - hd : 0;
                        map[y][x + halfStep] = average2 + rise2;
                    } else {
                        int s2 = map[y + halfStep][x + halfStep];
                        int e2 = map[y][x + step];
                        int w2 = map[y][x];
                        average = (s2 + e2 + w2) / 3;
                        d = diamondDisp / 3;
                        int n2 = rise = d > 0 ? rand.nextInt(d) - halfDmdDisp : 0;
                        if (average + rise > 0) {
                            rise = 0;
                        }
                        if (average > 0) {
                            average = 0;
                        }
                        map[y][x + halfStep] = average + rise;
                    }
                    if (x > 0) {
                        previous = x - halfStep;
                        n = map[y][x];
                        s = map[y + step][x];
                        e = map[y + halfStep][x + halfStep];
                        w = map[y + halfStep][previous];
                        average2 = (n + s + e + w) / 4;
                        d2 = diamondDisp;
                        if (doElevFactor) {
                            eFactor = maxHeight * 2 / 3 + average2 * 1 / 3;
                            d2 = d2 * eFactor / maxHeight;
                        }
                        hd = d2 >> 1;
                        rise2 = d2 > 0 ? rand.nextInt(d2) - hd : 0;
                        map[y + halfStep][x] = average2 + rise2;
                        continue;
                    }
                    int n3 = map[y][x];
                    int s3 = map[y + step][x];
                    int e3 = map[y + halfStep][x + halfStep];
                    average = (n3 + s3 + e3) / 3;
                    d = diamondDisp / 3;
                    int n4 = rise = d > 0 ? rand.nextInt(d) - halfDmdDisp : 0;
                    if (average + rise > 0) {
                        rise = 0;
                    }
                    if (average > 0) {
                        average = 0;
                    }
                    map[y + halfStep][x] = average + rise;
                }
            }
            step = halfStep;
            displacement /= displacementStep;
        }
        return result;
    }
}

