/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipLocator
implements AssetLocator {
    private ZipFile zipfile;
    private static final Logger logger = Logger.getLogger(ZipLocator.class.getName());

    @Override
    public void setRootPath(String rootPath) {
        try {
            this.zipfile = new ZipFile(new File(rootPath), 1);
        }
        catch (IOException ex) {
            throw new AssetLoadException("Failed to open zip file: " + rootPath, ex);
        }
    }

    @Override
    public AssetInfo locate(AssetManager manager, AssetKey key) {
        ZipEntry entry;
        String name = key.getName();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((entry = this.zipfile.getEntry(name)) == null) {
            return null;
        }
        return new JarAssetInfo(manager, key, entry);
    }

    private class JarAssetInfo
    extends AssetInfo {
        private final ZipEntry entry;

        public JarAssetInfo(AssetManager manager, AssetKey key, ZipEntry entry) {
            super(manager, key);
            this.entry = entry;
        }

        @Override
        public InputStream openStream() {
            try {
                return ZipLocator.this.zipfile.getInputStream(this.entry);
            }
            catch (IOException ex) {
                throw new AssetLoadException("Failed to load zip entry: " + this.entry, ex);
            }
        }
    }
}

