/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.anim;

import com.jme3.math.FastMath;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.anim.AbstractTween;
import com.simsilica.lemur.anim.Tween;

public class PanelTweens {
    public static Tween fade(Panel target, Float fromAlpha, Float toAlpha, double length) {
        if (fromAlpha == null) {
            fromAlpha = Float.valueOf(target.getAlpha());
        }
        if (toAlpha == null) {
            toAlpha = Float.valueOf(target.getAlpha());
        }
        return new Fade(target, fromAlpha.floatValue(), toAlpha.floatValue(), length);
    }

    private static class Fade
    extends AbstractTween {
        private final Panel target;
        private final float from;
        private final float to;

        public Fade(Panel target, float from, float to, double length) {
            super(length);
            this.target = target;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void doInterpolate(double t) {
            float value = FastMath.interpolateLinear((float)((float)t), (float)this.from, (float)this.to);
            this.target.setAlpha(value);
        }
    }
}

