/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import java.util.LinkedList;
import mythruna.text.md.BulletElement;
import mythruna.text.md.DirectiveElement;
import mythruna.text.md.HeaderElement;
import mythruna.text.md.HighlightElement;
import mythruna.text.md.ImageElement;
import mythruna.text.md.MarkdownBuffer;
import mythruna.text.md.MdElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownUtil {
    static Logger log = LoggerFactory.getLogger(MarkdownUtil.class);

    public static GuiLayout createLayout() {
        return new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.None);
    }

    public static Container createContainer(ElementId elementId) {
        return new Container(MarkdownUtil.createLayout(), elementId);
    }

    public static void populateContainer(Container container, float maxTextWidth, String text) {
        MarkdownUtil.populateContainer(container, maxTextWidth, new MarkdownBuffer(text));
    }

    public static void populateContainer(Container container, float maxTextWidth, MarkdownBuffer md) {
        container.clearChildren();
        LinkedList<ColumnTracker> columnStack = new LinkedList<ColumnTracker>();
        Container target = container;
        ElementId baseId = container.getElementId();
        for (MdElement el : md) {
            Label label;
            log.info("Processing:" + el);
            try {
                Label label2;
                if (el instanceof DirectiveElement) {
                    ColumnTracker columnTracker;
                    DirectiveElement directive = (DirectiveElement)el;
                    if ("begin-columns".equals(directive.getDirective())) {
                        columnTracker = new ColumnTracker(baseId, target);
                        columnStack.add(columnTracker);
                        target.addChild((Node)columnTracker.columns, new Object[0]);
                        target = columnTracker.newColumn();
                        continue;
                    }
                    if ("column".equals(directive.getDirective())) {
                        ColumnTracker columnTracker2 = columnTracker = columnStack.isEmpty() ? null : (ColumnTracker)columnStack.getLast();
                        if (columnTracker == null) {
                            columnTracker = new ColumnTracker(baseId, target);
                            columnStack.add(columnTracker);
                            target.addChild((Node)columnTracker.columns, new Object[0]);
                        }
                        target = columnTracker.newColumn();
                        continue;
                    }
                    if ("end-columns".equals(directive.getDirective())) {
                        columnTracker = (ColumnTracker)columnStack.removeLast();
                        if (columnTracker == null) {
                            Label label3 = new Label("unmatched {end-column}", baseId.child("text.label"));
                            target.addChild((Node)label3, new Object[0]);
                            continue;
                        }
                        if (!columnStack.isEmpty()) {
                            columnTracker = (ColumnTracker)columnStack.getLast();
                            target = columnTracker.currentColumn;
                            continue;
                        }
                        target = columnTracker.parent;
                        continue;
                    }
                    label = new Label("unknown directive:" + directive.getDirective(), baseId.child("text.label"));
                    target.addChild((Node)label, new Object[0]);
                    continue;
                }
                if (el instanceof HeaderElement) {
                    HeaderElement header = (HeaderElement)el;
                    label = new Label(el.getText(), baseId.child("h" + header.getLevel() + ".label"));
                    label.setMaxWidth(maxTextWidth);
                    target.addChild((Node)label, new Object[0]);
                    continue;
                }
                if (el instanceof BulletElement) {
                    BulletElement bullet = (BulletElement)el;
                    label = new Label(el.getText(), baseId.child("b" + bullet.getLevel() + ".label"));
                    label.setMaxWidth(maxTextWidth);
                    target.addChild((Node)label, new Object[0]);
                    continue;
                }
                if (el instanceof HighlightElement) {
                    label2 = new Label(el.getText(), baseId.child("highlight.label"));
                    label2.setMaxWidth(maxTextWidth);
                    target.addChild((Node)label2, new Object[0]);
                    continue;
                }
                if (el instanceof ImageElement) {
                    ImageElement image = (ImageElement)el;
                    label = new Label(el.getText(), baseId.child("image.label"));
                    float iconScale = Float.parseFloat(image.getStyle("scale", "1.0"));
                    try {
                        IconComponent icon = new IconComponent(image.getImagePath(), iconScale, 0.0f, 0.0f, 0.01f, false);
                        label.setIcon((GuiComponent)icon);
                    }
                    catch (RuntimeException e) {
                        log.error("Couldn't create icon for:" + image, (Throwable)e);
                        label.setText(image.getAltText() + " " + image.getText());
                    }
                    target.addChild((Node)label, new Object[0]);
                    continue;
                }
                label2 = new Label(el.getText(), baseId.child("text.label"));
                label2.setMaxWidth(maxTextWidth);
                target.addChild((Node)label2, new Object[0]);
            }
            catch (RuntimeException e) {
                log.error("Error processing element:" + el, (Throwable)e);
                label = new Label("markdown error", baseId.child("text.label"));
                target.addChild((Node)label, new Object[0]);
            }
        }
    }

    private static class ColumnTracker {
        private ElementId baseId;
        private Container parent;
        private Container columns;
        private Container currentColumn;
        private int count;

        public ColumnTracker(ElementId baseId, Container parent) {
            this.baseId = baseId;
            this.parent = parent;
            this.columns = new Container(baseId.child("columns.container"));
        }

        public Container newColumn() {
            this.currentColumn = new Container(this.baseId.child("column.container"));
            this.columns.addChild((Node)this.currentColumn, new Object[0]);
            ++this.count;
            return this.currentColumn;
        }
    }
}

