/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.bp;

import com.jme3.scene.Node;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.style.ElementId;
import java.io.File;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintFileSelectorDialog
extends Container {
    static Logger log = LoggerFactory.getLogger(BlueprintFileSelectorDialog.class);
    private File root;
    private Consumer<File> done;
    private VersionedList<File> files = new VersionedList();
    private ListBox<File> filesList;

    public BlueprintFileSelectorDialog(File root, Consumer<File> done) {
        super(new ElementId("window"));
        this.root = root;
        this.done = done;
        this.loadFiles();
        this.addChild((Node)new Label("Blueprint File Selector", this.getElementId().child("title")), new Object[0]);
        this.filesList = (ListBox)this.addChild((Node)new ListBox(this.files), new Object[0]);
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "select")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
    }

    protected void loadFiles() {
        if (!this.root.exists()) {
            return;
        }
        for (File f : this.root.listFiles()) {
            if (f.isDirectory() || !f.getName().toLowerCase().endsWith(".blocks")) continue;
            this.files.add((Object)f);
        }
    }

    protected void select() {
        File file = (File)this.filesList.getSelectedItem();
        if (file == null) {
            return;
        }
        this.done.accept(file);
        this.removeFromParent();
    }

    protected void cancel() {
        this.removeFromParent();
    }
}

