/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import java.util.Arrays;
import java.util.Random;
import org.progeeks.map.AbstractElevationGenerator;
import org.progeeks.map.ElevationData;

public class AdaptiveDiamondSquaresElevations
extends AbstractElevationGenerator {
    private double roughness = 3.0;
    private int roughnessBias = 5;
    private int seed;
    private int preseedFactor = 2;
    private double attenuation = 1.0;
    private int curveFactor = 1;

    public AdaptiveDiamondSquaresElevations() {
        super("Adaptive Diamond/Squares");
        this.setElevationScale(16500);
    }

    public void setSeed(int seed) {
        if (this.seed == seed) {
            return;
        }
        this.seed = seed;
        this.invalidate();
    }

    public int getSeed() {
        return this.seed;
    }

    public void setPreseedFrequency(int s) {
        int mapSize = this.getSourceData().getMapSize();
        int seedMax = (int)Math.round(Math.log(mapSize) / Math.log(2.0));
        if (s > seedMax) {
            s = seedMax;
        } else if (s < 0) {
            s = 0;
        }
        if (this.preseedFactor == s) {
            return;
        }
        this.preseedFactor = s;
        this.invalidate();
    }

    public int getPreseedFrequency() {
        return this.preseedFactor;
    }

    public void setRoughnessScale(double r) {
        if (this.roughness == r) {
            return;
        }
        this.roughness = r;
        this.invalidate();
    }

    public double getRoughnessScale() {
        return this.roughness;
    }

    public void setRoughnessBias(int bias) {
        if (this.roughnessBias == bias) {
            return;
        }
        this.roughnessBias = bias;
        this.invalidate();
    }

    public int getRoughnessBias() {
        return this.roughnessBias;
    }

    public void setAttenuation(double d) {
        if (this.attenuation == d) {
            return;
        }
        this.attenuation = d;
        this.invalidate();
    }

    public double getAttenuation() {
        return this.attenuation;
    }

    public void setCurveFactor(int i) {
        if (this.curveFactor == i) {
            return;
        }
        this.curveFactor = i;
        this.invalidate();
    }

    public int getCurveFactor() {
        return this.curveFactor;
    }

    private int getMax(int a, int b, int c, int d) {
        int max = a;
        if (max < b) {
            max = b;
        }
        if (max < c) {
            max = c;
        }
        if (max < d) {
            max = d;
        }
        return max;
    }

    private int getMin(int a, int b, int c, int d) {
        int min = a;
        if (min > b) {
            min = b;
        }
        if (min > c) {
            min = c;
        }
        if (min > d) {
            min = d;
        }
        return min;
    }

    private double getRoughnessScalar(int min, int max, int step, int displacement, int rise) {
        double elevationFactor = (double)(max - this.getElevationOffset()) / (double)this.getElevationScale();
        if (elevationFactor < 0.01) {
            elevationFactor = 0.01;
        }
        elevationFactor = Math.pow(elevationFactor, this.curveFactor);
        elevationFactor *= this.attenuation;
        double roughFactor = (double)(max - min) / (double)displacement;
        elevationFactor = Math.pow(elevationFactor, this.curveFactor);
        double stepRatio = 256.0 / (double)step;
        double stepFactor = 1.0 - (double)step / 256.0;
        double result = Math.min(1.0, elevationFactor * (roughFactor *= this.attenuation) + stepFactor);
        if (step == 128 || step == 64) {
            System.out.println("min:" + min + " max:" + max + " step:" + step + " disp:" + displacement + " rise:" + rise);
            System.out.println("  e factor:" + elevationFactor);
            System.out.println("  r factor:" + roughFactor);
            System.out.println("  s ratio:" + stepRatio);
            System.out.println("  s factor:" + stepFactor);
            System.out.println("    :" + elevationFactor * roughFactor);
            System.out.println("    :" + elevationFactor * roughFactor * stepFactor);
            System.out.println("    :" + result);
        }
        return result;
    }

    @Override
    protected ElevationData generateElevations(ElevationData result) {
        ElevationData source = this.getSourceData();
        int[][] sourceMap = source.getElevations();
        int mapSize = source.getMapSize();
        if (result == null) {
            result = new ElevationData(mapSize);
        }
        result.setElevationScale(this.getElevationScale());
        result.setElevationOffset(this.getElevationOffset());
        int sourceScale = source.getElevationScale();
        int sourceOffset = source.getElevationOffset();
        int scale = this.getElevationScale();
        int offset = this.getElevationOffset();
        int[][] map = result.getElevations();
        Random rand = new Random(this.getSeed());
        for (int y = 0; y <= mapSize; ++y) {
            Arrays.fill(map[y], offset);
        }
        int heightRange = scale;
        int maxHeight = scale - offset;
        int seedMax = (int)Math.round(Math.log(mapSize) / Math.log(2.0));
        int seedStep = seedMax - this.preseedFactor;
        seedStep = (int)Math.pow(2.0, seedStep);
        for (int x = 0; x <= mapSize; x += seedStep) {
            for (int y = 0; y <= mapSize; y += seedStep) {
                if (y == 0 || x == 0 || x == mapSize || y == mapSize) continue;
                map[y][x] = sourceMap[y][x] != 0 ? sourceMap[y][x] : offset + rand.nextInt(scale);
            }
        }
        double cos45 = Math.cos(Math.toRadians(45.0));
        int step = seedStep;
        double displacement = (double)(scale / 2) * this.roughness;
        double count = Math.log(step) / Math.log(2.0);
        double displacementStep = Math.exp(Math.log(displacement) / (count += (double)this.roughnessBias));
        while (step > 1) {
            int average;
            int halfStep = step / 2;
            int squareDisp = (int)displacement;
            int halfSqDisp = squareDisp / 2;
            for (int x = 0; x < mapSize; x += step) {
                for (int y = 0; y < mapSize; y += step) {
                    int nw = map[y][x];
                    int ne = map[y][x + step];
                    int sw = map[y + step][x];
                    int se = map[y + step][x + step];
                    int max = this.getMax(nw, ne, sw, se);
                    int min = this.getMin(nw, ne, sw, se);
                    average = (nw + ne + sw + se) / 4;
                    int rise = squareDisp > 0 ? rand.nextInt(squareDisp) - halfSqDisp : 0;
                    double scalar = this.getRoughnessScalar(min, max, step, squareDisp, rise);
                    rise = (int)Math.round((double)rise * scalar);
                    map[y + halfStep][x + halfStep] = average + rise;
                }
            }
            int diamondDisp = (int)Math.round(displacement * cos45);
            int halfDmdDisp = diamondDisp / 2;
            for (int x = 0; x < mapSize; x += step) {
                for (int y = 0; y < mapSize; y += step) {
                    int min;
                    int max;
                    int sampleCount;
                    int w;
                    int e;
                    int s;
                    int n;
                    int d = diamondDisp;
                    int hd = halfDmdDisp;
                    if (y > 0) {
                        int previous = y - halfStep;
                        n = map[previous][x + halfStep];
                        s = map[y + halfStep][x + halfStep];
                        e = map[y][x + step];
                        w = map[y][x];
                        sampleCount = 4;
                        max = this.getMax(n, s, e, w);
                        min = this.getMin(n, s, e, w);
                    } else {
                        n = 0;
                        s = map[y + halfStep][x + halfStep];
                        e = map[y][x + step];
                        w = map[y][x];
                        sampleCount = 3;
                        max = this.getMax(s, s, e, w);
                        min = this.getMin(s, s, e, w);
                        d /= 3;
                    }
                    average = (n + s + e + w) / sampleCount;
                    int rise = d > 0 ? rand.nextInt(d) - hd : 0;
                    double scalar = this.getRoughnessScalar(min, max, step, d, rise);
                    rise = (int)Math.round((double)rise * scalar);
                    if (y == 0) {
                        if (average + rise > 0) {
                            rise = 0;
                        }
                        if (average > 0) {
                            average = 0;
                        }
                    }
                    map[y][x + halfStep] = average + rise;
                    d = diamondDisp;
                    hd = halfDmdDisp;
                    if (x > 0) {
                        int previous = x - halfStep;
                        n = map[y][x];
                        s = map[y + step][x];
                        e = map[y + halfStep][x + halfStep];
                        w = map[y + halfStep][previous];
                        sampleCount = 4;
                        max = this.getMax(n, s, e, w);
                        min = this.getMin(n, s, e, w);
                    } else {
                        n = map[y][x];
                        s = map[y + step][x];
                        e = map[y + halfStep][x + halfStep];
                        w = 0;
                        sampleCount = 3;
                        max = this.getMax(n, s, e, e);
                        min = this.getMin(n, s, e, e);
                        d /= 3;
                    }
                    average = (n + s + e + w) / sampleCount;
                    rise = d > 0 ? rand.nextInt(d) - hd : 0;
                    scalar = this.getRoughnessScalar(min, max, step, d, rise);
                    rise = (int)Math.round((double)rise * scalar);
                    if (x == 0) {
                        if (average + rise > 0) {
                            rise = 0;
                        }
                        if (average > 0) {
                            average = 0;
                        }
                    }
                    map[y + halfStep][x] = average + rise;
                }
            }
            step = halfStep;
            displacement /= displacementStep;
        }
        return result;
    }
}

